/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSPolygon;
import java.util.Arrays;

public class Polygon
extends Geometry
implements SFSPolygon {
    protected LinearRing shell = null;
    protected LinearRing[] holes;

    public Polygon(LinearRing linearRing, PrecisionModel precisionModel, int n) {
        this(linearRing, new LinearRing[0], precisionModel, n);
    }

    public Polygon(LinearRing linearRing, LinearRing[] linearRingArray, PrecisionModel precisionModel, int n) {
        super(precisionModel, n);
        if (linearRing == null) {
            linearRing = new LinearRing(null, precisionModel, n);
        }
        if (linearRingArray == null) {
            linearRingArray = new LinearRing[]{};
        }
        if (Geometry.hasNullElements(linearRingArray)) {
            throw new IllegalArgumentException("holes must not contain null elements");
        }
        if (linearRing.isEmpty() && Geometry.hasNonEmptyElements(linearRingArray)) {
            throw new IllegalArgumentException("shell is empty but holes are not");
        }
        this.shell = linearRing;
        this.holes = linearRingArray;
    }

    public Coordinate getCoordinate() {
        return this.shell.getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        if (this.isEmpty()) {
            return new Coordinate[0];
        }
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        Coordinate[] coordinateArray2 = this.shell.getCoordinates();
        int n2 = 0;
        while (n2 < coordinateArray2.length) {
            coordinateArray[++n] = coordinateArray2[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.holes.length) {
            Coordinate[] coordinateArray3 = this.holes[n3].getCoordinates();
            int n4 = 0;
            while (n4 < coordinateArray3.length) {
                coordinateArray[++n] = coordinateArray3[n4];
                ++n4;
            }
            ++n3;
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        int n = this.shell.getNumPoints();
        int n2 = 0;
        while (n2 < this.holes.length) {
            n += this.holes[n2].getNumPoints();
            ++n2;
        }
        return n;
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public boolean isEmpty() {
        return this.shell.isEmpty();
    }

    public boolean isSimple() {
        return true;
    }

    public LineString getExteriorRing() {
        return this.shell;
    }

    public int getNumInteriorRing() {
        return this.holes.length;
    }

    public LineString getInteriorRingN(int n) {
        return this.holes[n];
    }

    public String getGeometryType() {
        return "Polygon";
    }

    public double getArea() {
        double d = 0.0;
        d += Math.abs(CGAlgorithms.signedArea(this.shell.getCoordinates()));
        int n = 0;
        while (n < this.holes.length) {
            d -= Math.abs(CGAlgorithms.signedArea(this.holes[n].getCoordinates()));
            ++n;
        }
        return d;
    }

    public double getLength() {
        double d = 0.0;
        d += this.shell.getLength();
        int n = 0;
        while (n < this.holes.length) {
            d += this.holes[n].getLength();
            ++n;
        }
        return d;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return new GeometryCollection(null, this.precisionModel, this.SRID);
        }
        LineString[] lineStringArray = new LinearRing[this.holes.length + 1];
        lineStringArray[0] = this.shell;
        int n = 0;
        while (n < this.holes.length) {
            lineStringArray[n + 1] = this.holes[n];
            ++n;
        }
        return new MultiLineString(lineStringArray, this.precisionModel, this.SRID);
    }

    protected Envelope computeEnvelopeInternal() {
        return this.shell.getEnvelopeInternal();
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        Polygon polygon = (Polygon)geometry;
        if (!(this.shell instanceof Geometry)) {
            return false;
        }
        LinearRing linearRing = this.shell;
        if (!(polygon.shell instanceof Geometry)) {
            return false;
        }
        LinearRing linearRing2 = polygon.shell;
        if (!((Geometry)linearRing).equalsExact(linearRing2, d)) {
            return false;
        }
        if (this.holes.length != polygon.holes.length) {
            return false;
        }
        if (this.holes.length != polygon.holes.length) {
            return false;
        }
        int n = 0;
        while (n < this.holes.length) {
            if (!(this.holes[n] instanceof Geometry)) {
                return false;
            }
            if (!(polygon.holes[n] instanceof Geometry)) {
                return false;
            }
            if (!((Geometry)this.holes[n]).equalsExact(polygon.holes[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        this.shell.apply(coordinateFilter);
        int n = 0;
        while (n < this.holes.length) {
            this.holes[n].apply(coordinateFilter);
            ++n;
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        this.shell.apply(geometryComponentFilter);
        int n = 0;
        while (n < this.holes.length) {
            this.holes[n].apply(geometryComponentFilter);
            ++n;
        }
    }

    public Object clone() {
        Polygon polygon = (Polygon)super.clone();
        polygon.shell = (LinearRing)this.shell.clone();
        polygon.holes = new LinearRing[this.holes.length];
        int n = 0;
        while (n < this.holes.length) {
            polygon.holes[n] = (LinearRing)this.holes[n].clone();
            ++n;
        }
        return polygon;
    }

    public Geometry convexHull() {
        return this.getExteriorRing().convexHull();
    }

    public void normalize() {
        this.normalize(this.shell, true);
        int n = 0;
        while (n < this.holes.length) {
            this.normalize(this.holes[n], false);
            ++n;
        }
        Arrays.sort(this.holes);
    }

    protected int compareToSameClass(Object object) {
        LinearRing linearRing = this.shell;
        LinearRing linearRing2 = ((Polygon)object).shell;
        return linearRing.compareToSameClass(linearRing2);
    }

    private void normalize(LinearRing linearRing, boolean bl) {
        if (linearRing.isEmpty()) {
            return;
        }
        Coordinate[] coordinateArray = new Coordinate[linearRing.getCoordinates().length - 1];
        System.arraycopy(linearRing.getCoordinates(), 0, coordinateArray, 0, coordinateArray.length);
        Coordinate coordinate = CoordinateArrays.minCoordinate(linearRing.getCoordinates());
        CoordinateArrays.scroll(coordinateArray, coordinate);
        System.arraycopy(coordinateArray, 0, linearRing.getCoordinates(), 0, coordinateArray.length);
        linearRing.getCoordinates()[coordinateArray.length] = coordinateArray[0];
        if (Geometry.cgAlgorithms.isCCW(linearRing.getCoordinates()) == bl) {
            CoordinateArrays.reverse(linearRing.getCoordinates());
        }
    }
}

