/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSPoint;

public class Point
extends Geometry
implements SFSPoint {
    protected Coordinate coordinate;

    public Point(Coordinate coordinate, PrecisionModel precisionModel, int n) {
        super(precisionModel, n);
        this.coordinate = coordinate;
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray;
        if (this.isEmpty()) {
            coordinateArray = new Coordinate[]{};
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[1];
            coordinateArray = coordinateArray2;
            coordinateArray2[0] = this.coordinate;
        }
        return coordinateArray;
    }

    public int getNumPoints() {
        return this.isEmpty() ? 0 : 1;
    }

    public boolean isEmpty() {
        return this.coordinate == null;
    }

    public boolean isSimple() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public int getDimension() {
        return 0;
    }

    public int getBoundaryDimension() {
        return -1;
    }

    public double getX() {
        if (this.coordinate == null) {
            throw new IllegalStateException("getX called on empty Point");
        }
        return this.coordinate.x;
    }

    public double getY() {
        if (this.coordinate == null) {
            throw new IllegalStateException("getY called on empty Point");
        }
        return this.coordinate.y;
    }

    public Coordinate getCoordinate() {
        return this.coordinate;
    }

    public String getGeometryType() {
        return "Point";
    }

    public Geometry getBoundary() {
        return new GeometryCollection(null, this.precisionModel, this.SRID);
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        return new Envelope(this.coordinate.x, this.coordinate.x, this.coordinate.y, this.coordinate.y);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        if (this.isEmpty() && geometry.isEmpty()) {
            return true;
        }
        return this.equal(((Point)geometry).coordinate, this.coordinate, d);
    }

    public void apply(CoordinateFilter coordinateFilter) {
        if (this.isEmpty()) {
            return;
        }
        coordinateFilter.filter(this.coordinate);
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    public Object clone() {
        Point point = (Point)super.clone();
        point.coordinate = this.coordinate != null ? (Coordinate)this.coordinate.clone() : null;
        return point;
    }

    public void normalize() {
    }

    protected int compareToSameClass(Object object) {
        Point point = (Point)object;
        return this.coordinate.compareTo(point.getCoordinate());
    }
}

