/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSMultiPolygon;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection
implements SFSMultiPolygon {
    public MultiPolygon(Polygon[] polygonArray, PrecisionModel precisionModel, int n) {
        super(polygonArray, precisionModel, n);
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public String getGeometryType() {
        return "MultiPolygon";
    }

    public boolean isSimple() {
        return true;
    }

    public Geometry getBoundary() {
        Object object;
        if (this.isEmpty()) {
            return new GeometryCollection(null, this.precisionModel, this.SRID);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        int n = 0;
        while (n < this.geometries.length) {
            object = (Polygon)this.geometries[n];
            GeometryCollection geometryCollection = (GeometryCollection)((Polygon)object).getBoundary();
            int n2 = 0;
            while (n2 < geometryCollection.getNumGeometries()) {
                arrayList.add(geometryCollection.getGeometryN(n2));
                ++n2;
            }
            ++n;
        }
        object = new LineString[arrayList.size()];
        return new MultiLineString((LineString[])arrayList.toArray((T[])object), this.precisionModel, this.SRID);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }
}

