/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSMultiLineString;
import com.vividsolutions.jts.graph.GeometryGraph;
import com.vividsolutions.jts.operation.IsSimpleOp;

public class MultiLineString
extends GeometryCollection
implements SFSMultiLineString {
    public MultiLineString(LineString[] lineStringArray, PrecisionModel precisionModel, int n) {
        super(lineStringArray, precisionModel, n);
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        int n = 0;
        while (n < this.geometries.length) {
            if (!((LineString)this.geometries[n]).isClosed()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean isSimple() {
        return new IsSimpleOp().isSimple(this);
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return new GeometryCollection(null, this.precisionModel, this.SRID);
        }
        GeometryGraph geometryGraph = new GeometryGraph(0, this);
        Coordinate[] coordinateArray = geometryGraph.getBoundaryPoints();
        GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, this.SRID);
        return geometryFactory.createMultiPoint(coordinateArray);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }
}

