/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSLineString;
import com.vividsolutions.jts.operation.IsSimpleOp;

public class LineString
extends Geometry
implements SFSLineString {
    protected Coordinate[] points;

    public LineString(Coordinate[] coordinateArray, PrecisionModel precisionModel, int n) {
        super(precisionModel, n);
        if (coordinateArray == null) {
            coordinateArray = new Coordinate[]{};
        }
        if (Geometry.hasNullElements(coordinateArray)) {
            throw new IllegalArgumentException("point array must not contain null elements");
        }
        if (coordinateArray.length == 1) {
            throw new IllegalArgumentException("point array must contain 0 or >1 elements");
        }
        this.points = coordinateArray;
    }

    public Coordinate[] getCoordinates() {
        return this.points;
    }

    public Coordinate getCoordinateN(int n) {
        return this.points[n];
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.points[0];
    }

    public int getDimension() {
        return 1;
    }

    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.points.length == 0;
    }

    public int getNumPoints() {
        return this.points.length;
    }

    public Point getPointN(int n) {
        return new Point(this.points[n], this.getPrecisionModel(), this.SRID);
    }

    public Point getStartPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(0);
    }

    public Point getEndPoint() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getPointN(this.getNumPoints() - 1);
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getCoordinateN(0).equals2D(this.getCoordinateN(this.getNumPoints() - 1));
    }

    public boolean isRing() {
        return this.isClosed() && this.isSimple();
    }

    public String getGeometryType() {
        return "LineString";
    }

    public double getLength() {
        return CGAlgorithms.length(this.points);
    }

    public boolean isSimple() {
        return new IsSimpleOp().isSimple(this);
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return new GeometryCollection(null, this.precisionModel, this.SRID);
        }
        if (this.isClosed()) {
            return new MultiPoint(null, this.precisionModel, this.SRID);
        }
        return new MultiPoint(new Point[]{this.getStartPoint(), this.getEndPoint()}, this.precisionModel, this.SRID);
    }

    public boolean isCoordinate(Coordinate coordinate) {
        int n = 1;
        while (n < this.points.length) {
            if (this.points[n].equals(coordinate)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected Envelope computeEnvelopeInternal() {
        if (this.isEmpty()) {
            return new Envelope();
        }
        double d = this.points[0].x;
        double d2 = this.points[0].y;
        double d3 = this.points[0].x;
        double d4 = this.points[0].y;
        int n = 1;
        while (n < this.points.length) {
            d = Math.min(d, this.points[n].x);
            d3 = Math.max(d3, this.points[n].x);
            d2 = Math.min(d2, this.points[n].y);
            d4 = Math.max(d4, this.points[n].y);
            ++n;
        }
        return new Envelope(d, d3, d2, d4);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        LineString lineString = (LineString)geometry;
        if (this.points.length != lineString.points.length) {
            return false;
        }
        int n = 0;
        while (n < this.points.length) {
            if (!this.equal(this.points[n], lineString.points[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        int n = 0;
        while (n < this.points.length) {
            coordinateFilter.filter(this.points[n]);
            ++n;
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
    }

    public Object clone() {
        LineString lineString = (LineString)super.clone();
        Coordinate[] coordinateArray = new Coordinate[this.points.length];
        lineString.points = coordinateArray;
        int n = 0;
        while (n < this.points.length) {
            lineString.points[n] = (Coordinate)this.points[n].clone();
            ++n;
        }
        return lineString;
    }

    public void normalize() {
        int n = 0;
        while (n < this.points.length / 2) {
            int n2 = this.points.length - 1 - n;
            if (!this.points[n].equals(this.points[n2])) {
                if (this.points[n].compareTo(this.points[n2]) > 0) {
                    CoordinateArrays.reverse(this.points);
                }
                return;
            }
            ++n;
        }
    }

    protected boolean isEquivalentClass(Geometry geometry) {
        return geometry instanceof LineString;
    }

    protected int compareToSameClass(Object object) {
        LineString lineString = (LineString)object;
        int n = 0;
        int n2 = 0;
        while (n < this.points.length && n2 < lineString.points.length) {
            int n3 = this.points[n].compareTo(lineString.points[n2]);
            if (n3 != 0) {
                return n3;
            }
            ++n;
            ++n2;
        }
        if (n < this.points.length) {
            return 1;
        }
        if (n2 < lineString.points.length) {
            return -1;
        }
        return 0;
    }
}

