/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeometryFactory {
    private PrecisionModel precisionModel;
    private int SRID;

    public static Point createPointFromInternalCoord(Coordinate coordinate, Geometry geometry) {
        geometry.getPrecisionModel().makePrecise(coordinate);
        return new Point(coordinate, geometry.getPrecisionModel(), geometry.getSRID());
    }

    public GeometryFactory(PrecisionModel precisionModel, int n) {
        this.precisionModel = precisionModel;
        this.SRID = n;
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    public static Point[] toPointArray(List list) {
        Point[] pointArray = new Point[list.size()];
        return list.toArray(pointArray);
    }

    public static Geometry[] toGeometryArray(List list) {
        if (list == null) {
            return null;
        }
        Geometry[] geometryArray = new Geometry[list.size()];
        return list.toArray(geometryArray);
    }

    public static LinearRing[] toLinearRingArray(List list) {
        LinearRing[] linearRingArray = new LinearRing[list.size()];
        return list.toArray(linearRingArray);
    }

    public static LineString[] toLineStringArray(List list) {
        LineString[] lineStringArray = new LineString[list.size()];
        return list.toArray(lineStringArray);
    }

    public static Polygon[] toPolygonArray(List list) {
        Polygon[] polygonArray = new Polygon[list.size()];
        return list.toArray(polygonArray);
    }

    public static MultiPolygon[] toMultiPolygonArray(List list) {
        MultiPolygon[] multiPolygonArray = new MultiPolygon[list.size()];
        return list.toArray(multiPolygonArray);
    }

    public static MultiLineString[] toMultiLineStringArray(List list) {
        MultiLineString[] multiLineStringArray = new MultiLineString[list.size()];
        return list.toArray(multiLineStringArray);
    }

    public static MultiPoint[] toMultiPointArray(List list) {
        MultiPoint[] multiPointArray = new MultiPoint[list.size()];
        return list.toArray(multiPointArray);
    }

    public static Geometry toGeometry(Envelope envelope, PrecisionModel precisionModel, int n) {
        if (envelope.isNull()) {
            return new Point(null, precisionModel, n);
        }
        if (envelope.getMinX() == envelope.getMaxX() && envelope.getMinY() == envelope.getMaxY()) {
            return new Point(new Coordinate(envelope.getMinX(), envelope.getMinY()), precisionModel, n);
        }
        return new Polygon(new LinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}, precisionModel, n), precisionModel, n);
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public Point createPoint(Coordinate coordinate) {
        return new Point(coordinate, this.precisionModel, this.SRID);
    }

    public MultiLineString createMultiLineString(LineString[] lineStringArray) {
        return new MultiLineString(lineStringArray, this.precisionModel, this.SRID);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometryArray) {
        return new GeometryCollection(geometryArray, this.precisionModel, this.SRID);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygonArray) {
        return new MultiPolygon(polygonArray, this.precisionModel, this.SRID);
    }

    public LinearRing createLinearRing(Coordinate[] coordinateArray) {
        LinearRing linearRing = new LinearRing(coordinateArray, this.precisionModel, this.SRID);
        if (coordinateArray != null && coordinateArray.length > 0 && !coordinateArray[0].equals2D(coordinateArray[coordinateArray.length - 1])) {
            throw new IllegalArgumentException("LinearRing not closed");
        }
        return linearRing;
    }

    public MultiPoint createMultiPoint(Point[] pointArray) {
        return new MultiPoint(pointArray, this.precisionModel, this.SRID);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinateArray) {
        if (coordinateArray == null) {
            coordinateArray = new Coordinate[]{};
        }
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = 0;
        while (n < coordinateArray.length) {
            arrayList.add(this.createPoint(coordinateArray[n]));
            ++n;
        }
        return this.createMultiPoint(arrayList.toArray(new Point[0]));
    }

    public Polygon createPolygon(LinearRing linearRing, LinearRing[] linearRingArray) {
        return new Polygon(linearRing, linearRingArray, this.precisionModel, this.SRID);
    }

    public Geometry buildGeometry(List list) {
        Geometry geometry;
        Class<?> clazz = null;
        boolean bl = false;
        boolean bl2 = list.size() > 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            geometry = (Geometry)iterator.next();
            Class<?> clazz2 = geometry.getClass();
            if (clazz == null) {
                clazz = clazz2;
            }
            if (clazz2 == clazz) continue;
            bl = true;
        }
        if (clazz == null) {
            return this.createGeometryCollection(null);
        }
        if (bl) {
            return this.createGeometryCollection(GeometryFactory.toGeometryArray(list));
        }
        geometry = (Geometry)list.get(0);
        if (bl2) {
            if (geometry instanceof Polygon) {
                return this.createMultiPolygon(GeometryFactory.toPolygonArray(list));
            }
            if (geometry instanceof LineString) {
                return this.createMultiLineString(GeometryFactory.toLineStringArray(list));
            }
            if (geometry instanceof Point) {
                return this.createMultiPoint(GeometryFactory.toPointArray(list));
            }
            Assert.shouldNeverReachHere();
        }
        return geometry;
    }

    public LineString createLineString(Coordinate[] coordinateArray) {
        return new LineString(coordinateArray, this.precisionModel, this.SRID);
    }
}

