/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.algorithm.CentroidArea;
import com.vividsolutions.jts.algorithm.CentroidLine;
import com.vividsolutions.jts.algorithm.CentroidPoint;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.sfs.SFSGeometryCollection;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry
implements SFSGeometryCollection {
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometryArray, PrecisionModel precisionModel, int n) {
        super(precisionModel, n);
        if (geometryArray == null) {
            geometryArray = new Geometry[]{};
        }
        if (Geometry.hasNullElements(geometryArray)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometryArray;
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        int n2 = 0;
        while (n2 < this.geometries.length) {
            Coordinate[] coordinateArray2 = this.geometries[n2].getCoordinates();
            int n3 = 0;
            while (n3 < coordinateArray2.length) {
                coordinateArray[++n] = coordinateArray2[n3];
                ++n3;
            }
            ++n2;
        }
        return coordinateArray;
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.geometries.length) {
            if (!this.geometries[n].isEmpty()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getDimension() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.geometries.length) {
            n = Math.max(n, this.geometries[n2].getDimension());
            ++n2;
        }
        return n;
    }

    public int getBoundaryDimension() {
        int n = -1;
        int n2 = 0;
        while (n2 < this.geometries.length) {
            n = Math.max(n, this.geometries[n2].getBoundaryDimension());
            ++n2;
        }
        return n;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    public int getNumPoints() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.geometries.length) {
            n += this.geometries[n2].getNumPoints();
            ++n2;
        }
        return n;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public boolean isSimple() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return false;
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    public double getArea() {
        double d = 0.0;
        int n = 0;
        while (n < this.geometries.length) {
            d += this.geometries[n].getArea();
            ++n;
        }
        return d;
    }

    public double getLength() {
        double d = 0.0;
        int n = 0;
        while (n < this.geometries.length) {
            d += this.geometries[n].getLength();
            ++n;
        }
        return d;
    }

    public Point getCentroid() {
        Coordinate coordinate = null;
        int n = this.getDimension();
        if (n == 0) {
            CentroidPoint centroidPoint = new CentroidPoint();
            centroidPoint.add(this);
            coordinate = centroidPoint.getCentroid();
        } else if (n == 1) {
            CentroidLine centroidLine = new CentroidLine();
            centroidLine.add(this);
            coordinate = centroidLine.getCentroid();
        } else {
            CentroidArea centroidArea = new CentroidArea();
            centroidArea.add(this);
            coordinate = centroidArea.getCentroid();
        }
        return GeometryFactory.createPointFromInternalCoord(coordinate, this);
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        GeometryCollection geometryCollection = (GeometryCollection)geometry;
        if (this.geometries.length != geometryCollection.geometries.length) {
            return false;
        }
        if (this.geometries.length != geometryCollection.geometries.length) {
            return false;
        }
        int n = 0;
        while (n < this.geometries.length) {
            if (!(this.geometries[n] instanceof Geometry)) {
                return false;
            }
            if (!(geometryCollection.geometries[n] instanceof Geometry)) {
                return false;
            }
            if (!this.geometries[n].equalsExact(geometryCollection.geometries[n], d)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        int n = 0;
        while (n < this.geometries.length) {
            this.geometries[n].apply(coordinateFilter);
            ++n;
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
        int n = 0;
        while (n < this.geometries.length) {
            this.geometries[n].apply(geometryFilter);
            ++n;
        }
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        int n = 0;
        while (n < this.geometries.length) {
            this.geometries[n].apply(geometryComponentFilter);
            ++n;
        }
    }

    public Object clone() {
        GeometryCollection geometryCollection = (GeometryCollection)super.clone();
        geometryCollection.geometries = new Geometry[this.geometries.length];
        int n = 0;
        while (n < this.geometries.length) {
            geometryCollection.geometries[n] = (Geometry)this.geometries[n].clone();
            ++n;
        }
        return geometryCollection;
    }

    public void normalize() {
        int n = 0;
        while (n < this.geometries.length) {
            this.geometries[n].normalize();
            ++n;
        }
        Arrays.sort(this.geometries);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        int n = 0;
        while (n < this.geometries.length) {
            envelope.expandToInclude(this.geometries[n].getEnvelopeInternal());
            ++n;
        }
        return envelope;
    }

    protected int compareToSameClass(Object object) {
        TreeSet<Geometry> treeSet = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> treeSet2 = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)object).geometries));
        return this.compare(treeSet, treeSet2);
    }
}

