/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import java.io.Serializable;

public class Envelope
implements Serializable {
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return coordinate3.x >= Math.min(coordinate.x, coordinate2.x) && coordinate3.x <= Math.max(coordinate.x, coordinate2.x) && coordinate3.y >= Math.min(coordinate.y, coordinate2.y) && coordinate3.y <= Math.max(coordinate.y, coordinate2.y);
    }

    public static boolean intersects(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        double d = Math.min(coordinate3.x, coordinate4.x);
        double d2 = Math.max(coordinate3.x, coordinate4.x);
        double d3 = Math.min(coordinate.x, coordinate2.x);
        double d4 = Math.max(coordinate.x, coordinate2.x);
        if (d3 > d2) {
            return false;
        }
        if (d4 < d) {
            return false;
        }
        d = Math.min(coordinate3.y, coordinate4.y);
        d2 = Math.max(coordinate3.y, coordinate4.y);
        d3 = Math.min(coordinate.y, coordinate2.y);
        d4 = Math.max(coordinate.y, coordinate2.y);
        if (d3 > d2) {
            return false;
        }
        return !(d4 < d);
    }

    private static double distance(double d, double d2, double d3, double d4) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        return Math.sqrt(d5 * d5 + d6 * d6);
    }

    public Envelope() {
        this.init();
    }

    public Envelope(double d, double d2, double d3, double d4) {
        this.init(d, d2, d3, d4);
    }

    public Envelope(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate, coordinate2);
    }

    public Envelope(Coordinate coordinate) {
        this.init(coordinate);
    }

    public Envelope(Envelope envelope) {
        this.init(envelope);
    }

    public void init() {
        this.setToNull();
    }

    public void init(double d, double d2, double d3, double d4) {
        if (d < d2) {
            this.minx = d;
            this.maxx = d2;
        } else {
            this.minx = d2;
            this.maxx = d;
        }
        if (d3 < d4) {
            this.miny = d3;
            this.maxy = d4;
        } else {
            this.miny = d4;
            this.maxy = d3;
        }
    }

    public void init(Coordinate coordinate, Coordinate coordinate2) {
        this.init(coordinate.x, coordinate2.x, coordinate.y, coordinate2.y);
    }

    public void init(Coordinate coordinate) {
        this.init(coordinate.x, coordinate.x, coordinate.y, coordinate.y);
    }

    public void init(Envelope envelope) {
        this.init(envelope.minx, envelope.maxx, envelope.miny, envelope.maxy);
    }

    public void setToNull() {
        this.minx = 0.0;
        this.maxx = -1.0;
        this.miny = 0.0;
        this.maxy = -1.0;
    }

    public boolean isNull() {
        return this.maxx < this.minx;
    }

    public double getWidth() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxx - this.minx;
    }

    public double getHeight() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.maxy - this.miny;
    }

    public double getMinX() {
        return this.minx;
    }

    public double getMaxX() {
        return this.maxx;
    }

    public double getMinY() {
        return this.miny;
    }

    public double getMaxY() {
        return this.maxy;
    }

    public void expandToInclude(Coordinate coordinate) {
        this.expandToInclude(coordinate.x, coordinate.y);
    }

    public void expandToInclude(double d, double d2) {
        if (this.isNull()) {
            this.minx = d;
            this.maxx = d;
            this.miny = d2;
            this.maxy = d2;
        } else {
            if (d < this.minx) {
                this.minx = d;
            }
            if (d > this.maxx) {
                this.maxx = d;
            }
            if (d2 < this.miny) {
                this.miny = d2;
            }
            if (d2 > this.maxy) {
                this.maxy = d2;
            }
        }
    }

    public void expandToInclude(Envelope envelope) {
        if (envelope.isNull()) {
            return;
        }
        if (this.isNull()) {
            this.minx = envelope.getMinX();
            this.maxx = envelope.getMaxX();
            this.miny = envelope.getMinY();
            this.maxy = envelope.getMaxY();
        } else {
            if (envelope.minx < this.minx) {
                this.minx = envelope.minx;
            }
            if (envelope.maxx > this.maxx) {
                this.maxx = envelope.maxx;
            }
            if (envelope.miny < this.miny) {
                this.miny = envelope.miny;
            }
            if (envelope.maxy > this.maxy) {
                this.maxy = envelope.maxy;
            }
        }
    }

    public boolean contains(Coordinate coordinate) {
        return this.contains(coordinate.x, coordinate.y);
    }

    public boolean contains(double d, double d2) {
        return d >= this.minx && d <= this.maxx && d2 >= this.miny && d2 <= this.maxy;
    }

    public boolean intersects(Envelope envelope) {
        return !(envelope.getMinX() > this.maxx || envelope.getMaxX() < this.minx || envelope.getMinY() > this.maxy || envelope.getMaxY() < this.miny);
    }

    public boolean overlaps(Envelope envelope) {
        return this.intersects(envelope);
    }

    public boolean intersects(Coordinate coordinate) {
        return this.intersects(coordinate.x, coordinate.y);
    }

    public boolean overlaps(Coordinate coordinate) {
        return this.intersects(coordinate);
    }

    public boolean intersects(double d, double d2) {
        return !(d > this.maxx || d < this.minx || d2 > this.maxy || d2 < this.miny);
    }

    public boolean overlaps(double d, double d2) {
        return this.intersects(d, d2);
    }

    public boolean contains(Envelope envelope) {
        return envelope.getMinX() >= this.minx && envelope.getMaxX() <= this.maxx && envelope.getMinY() >= this.miny && envelope.getMaxY() <= this.maxy;
    }

    public double distance(Envelope envelope) {
        if (this.intersects(envelope)) {
            return 0.0;
        }
        double d = 0.0;
        if (this.maxx < envelope.minx) {
            d = envelope.minx - this.maxx;
        }
        if (this.minx > envelope.maxx) {
            d = this.minx - envelope.maxx;
        }
        double d2 = 0.0;
        if (this.maxy < envelope.miny) {
            d2 = envelope.miny - this.maxy;
        }
        if (this.miny > envelope.maxy) {
            d2 = this.miny - envelope.maxy;
        }
        if (d == 0.0) {
            return d2;
        }
        if (d2 == 0.0) {
            return d;
        }
        return Math.sqrt(d * d + d2 * d2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Envelope)) {
            return false;
        }
        Envelope envelope = (Envelope)object;
        if (this.isNull()) {
            return envelope.isNull();
        }
        return this.maxx == envelope.getMaxX() && this.maxy == envelope.getMaxY() && this.minx == envelope.getMinX() && this.maxx == envelope.getMaxX();
    }

    public String toString() {
        return "Env[" + this.minx + " : " + this.maxx + ", " + this.miny + " : " + this.maxy + "]";
    }
}

