/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import java.util.List;

public class CoordinateArrays {
    private static final Coordinate[] coordArrayType = new Coordinate[0];

    public static Coordinate[] toCoordinateArray(List list) {
        return list.toArray(coordArrayType);
    }

    public static boolean hasRepeatedPoints(Coordinate[] coordinateArray) {
        int n = 1;
        while (n < coordinateArray.length) {
            if (coordinateArray[n - 1].equals(coordinateArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static Coordinate[] removeRepeatedPoints(Coordinate[] coordinateArray) {
        if (!CoordinateArrays.hasRepeatedPoints(coordinateArray)) {
            return coordinateArray;
        }
        CoordinateList coordinateList = new CoordinateList(coordinateArray, false);
        return coordinateList.toCoordinateArray();
    }

    public static void reverse(Coordinate[] coordinateArray) {
        int n = coordinateArray.length - 1;
        int n2 = n / 2;
        int n3 = 0;
        while (n3 <= n2) {
            Coordinate coordinate = coordinateArray[n3];
            coordinateArray[n3] = coordinateArray[n - n3];
            coordinateArray[n - n3] = coordinate;
            ++n3;
        }
    }

    public static boolean equals(Coordinate[] coordinateArray, Coordinate[] coordinateArray2) {
        if (coordinateArray == coordinateArray2) {
            return true;
        }
        if (coordinateArray == null || coordinateArray2 == null) {
            return false;
        }
        if (coordinateArray.length != coordinateArray2.length) {
            return false;
        }
        int n = 0;
        while (n < coordinateArray.length) {
            if (!coordinateArray[n].equals(coordinateArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected static Coordinate minCoordinate(Coordinate[] coordinateArray) {
        Coordinate coordinate = null;
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate == null || coordinate.compareTo(coordinateArray[n]) > 0) {
                coordinate = coordinateArray[n];
            }
            ++n;
        }
        return coordinate;
    }

    protected static void scroll(Coordinate[] coordinateArray, Coordinate coordinate) {
        int n = CoordinateArrays.indexOf(coordinate, coordinateArray);
        if (n < 0) {
            return;
        }
        Coordinate[] coordinateArray2 = new Coordinate[coordinateArray.length];
        System.arraycopy(coordinateArray, n, coordinateArray2, 0, coordinateArray.length - n);
        System.arraycopy(coordinateArray, 0, coordinateArray2, coordinateArray.length - n, n);
        System.arraycopy(coordinateArray2, 0, coordinateArray, 0, coordinateArray.length);
    }

    protected static int indexOf(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length) {
            if (coordinate.equals(coordinateArray[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

