/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;

public class Coordinate
implements Comparable,
Cloneable,
Serializable {
    public double x;
    public double y;
    public double z;

    public Coordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Coordinate() {
        this(0.0, 0.0);
    }

    public Coordinate(Coordinate coordinate) {
        this(coordinate.x, coordinate.y, coordinate.z);
    }

    public Coordinate(double d, double d2) {
        this(d, d2, Double.NaN);
    }

    public void setCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.z = coordinate.z;
    }

    public boolean equals2D(Coordinate coordinate) {
        if (this.x != coordinate.x) {
            return false;
        }
        return this.y == coordinate.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Coordinate)) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        return this.x == coordinate.x && this.y == coordinate.y && (this.z == coordinate.z || Double.isNaN(this.z) && Double.isNaN(coordinate.z));
    }

    public int compareTo(Object object) {
        Coordinate coordinate = (Coordinate)object;
        if (this.x < coordinate.x) {
            return -1;
        }
        if (this.x > coordinate.x) {
            return 1;
        }
        if (this.y < coordinate.y) {
            return -1;
        }
        if (this.y > coordinate.y) {
            return 1;
        }
        return 0;
    }

    public boolean equals3D(Object object) {
        if (!(object instanceof Coordinate)) {
            return false;
        }
        Coordinate coordinate = (Coordinate)object;
        return this.x == coordinate.x && this.y == coordinate.y && (this.z == coordinate.z || Double.isNaN(this.z) && Double.isNaN(coordinate.z));
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public Object clone() {
        try {
            Coordinate coordinate = (Coordinate)super.clone();
            return coordinate;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.shouldNeverReachHere("this shouldn't happen because this class is Cloneable");
            return null;
        }
    }

    public double distance(Coordinate coordinate) {
        double d = this.x - coordinate.x;
        double d2 = this.y - coordinate.y;
        return Math.sqrt(d * d + d2 * d2);
    }
}

