/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustDeterminant;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;

public class RobustCGAlgorithms
extends CGAlgorithms {
    public static int orientationIndex(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate2.y - coordinate.y;
        double d3 = coordinate3.x - coordinate2.x;
        double d4 = coordinate3.y - coordinate2.y;
        return RobustDeterminant.signOfDet2x2(d, d2, d3, d4);
    }

    public boolean isCCW(Coordinate[] coordinateArray) {
        Coordinate coordinate;
        Coordinate coordinate2;
        int n;
        int n2;
        int n3 = coordinateArray.length;
        if (n3 < 4) {
            return false;
        }
        Coordinate coordinate3 = coordinateArray[0];
        int n4 = 0;
        int n5 = 1;
        while (n5 < n3) {
            Coordinate coordinate4 = coordinateArray[n5];
            if (coordinate4.y > coordinate3.y) {
                coordinate3 = coordinate4;
                n4 = n5;
            }
            ++n5;
        }
        int n6 = n4 - 1;
        if (n6 < 0) {
            n6 = n3 - 2;
        }
        if ((n2 = n4 + 1) >= n3) {
            n2 = 1;
        }
        if ((n = this.computeOrientation(coordinate2 = coordinateArray[n6], coordinate3, coordinate = coordinateArray[n2])) == 0) {
            return coordinate2.x > coordinate.x;
        }
        return n > 0;
    }

    public boolean isPointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        int n2 = coordinateArray.length;
        int n3 = 1;
        while (n3 < n2) {
            double d;
            int n4 = n3 - 1;
            Coordinate coordinate2 = coordinateArray[n3];
            Coordinate coordinate3 = coordinateArray[n4];
            double d2 = coordinate2.x - coordinate.x;
            double d3 = coordinate2.y - coordinate.y;
            double d4 = coordinate3.x - coordinate.x;
            double d5 = coordinate3.y - coordinate.y;
            if ((d3 > 0.0 && d5 <= 0.0 || d5 > 0.0 && d3 <= 0.0) && 0.0 < (d = (double)RobustDeterminant.signOfDet2x2(d2, d3, d4, d5) / (d5 - d3))) {
                ++n;
            }
            ++n3;
        }
        return n % 2 == 1;
    }

    public boolean isOnLine(Coordinate coordinate, Coordinate[] coordinateArray) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        int n = 1;
        while (n < coordinateArray.length) {
            Coordinate coordinate2 = coordinateArray[n - 1];
            Coordinate coordinate3 = coordinateArray[n];
            ((LineIntersector)robustLineIntersector).computeIntersection(coordinate, coordinate2, coordinate3);
            if (robustLineIntersector.hasIntersection()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int computeOrientation(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return RobustCGAlgorithms.orientationIndex(coordinate, coordinate2, coordinate3);
    }

    private boolean isInEnvelope(Coordinate coordinate, Coordinate[] coordinateArray) {
        Envelope envelope = new Envelope();
        int n = 0;
        while (n < coordinateArray.length) {
            envelope.expandToInclude(coordinateArray[n]);
            ++n;
        }
        return envelope.contains(coordinate);
    }
}

