/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.graph.GeometryGraph;

public class PointLocator {
    private CGAlgorithms cga = new RobustCGAlgorithms();
    private boolean isIn;
    private int numBoundaries;

    public boolean intersects(Coordinate coordinate, Geometry geometry) {
        return this.locate(coordinate, geometry) != 2;
    }

    public int locate(Coordinate coordinate, Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        if (geometry instanceof LineString) {
            return this.locate(coordinate, (LineString)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.locate(coordinate, (LinearRing)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.locate(coordinate, (Polygon)geometry);
        }
        this.isIn = false;
        this.numBoundaries = 0;
        this.computeLocation(coordinate, geometry);
        if (GeometryGraph.isInBoundary(this.numBoundaries)) {
            return 1;
        }
        if (this.numBoundaries > 0 || this.isIn) {
            return 0;
        }
        return 2;
    }

    private void computeLocation(Coordinate coordinate, Geometry geometry) {
        block5: {
            block8: {
                block7: {
                    block6: {
                        block4: {
                            if (geometry instanceof LineString) {
                                this.updateLocationInfo(this.locate(coordinate, (LineString)geometry));
                            }
                            if (!(geometry instanceof LinearRing)) break block4;
                            this.updateLocationInfo(this.locate(coordinate, (LinearRing)geometry));
                            break block5;
                        }
                        if (!(geometry instanceof Polygon)) break block6;
                        this.updateLocationInfo(this.locate(coordinate, (Polygon)geometry));
                        break block5;
                    }
                    if (!(geometry instanceof MultiLineString)) break block7;
                    MultiLineString multiLineString = (MultiLineString)geometry;
                    int n = 0;
                    while (n < multiLineString.getNumGeometries()) {
                        LineString lineString = (LineString)multiLineString.getGeometryN(n);
                        this.updateLocationInfo(this.locate(coordinate, lineString));
                        ++n;
                    }
                    break block5;
                }
                if (!(geometry instanceof MultiPolygon)) break block8;
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                int n = 0;
                while (n < multiPolygon.getNumGeometries()) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(n);
                    this.updateLocationInfo(this.locate(coordinate, polygon));
                    ++n;
                }
                break block5;
            }
            if (!(geometry instanceof GeometryCollection)) break block5;
            GeometryCollectionIterator geometryCollectionIterator = new GeometryCollectionIterator((GeometryCollection)geometry);
            while (geometryCollectionIterator.hasNext()) {
                Geometry geometry2 = (Geometry)geometryCollectionIterator.next();
                if (geometry2 == geometry) continue;
                this.computeLocation(coordinate, geometry2);
            }
        }
    }

    private void updateLocationInfo(int n) {
        if (n == 0) {
            this.isIn = true;
        }
        if (n == 1) {
            ++this.numBoundaries;
        }
    }

    private int locate(Coordinate coordinate, LineString lineString) {
        Coordinate[] coordinateArray = lineString.getCoordinates();
        if (!lineString.isClosed() && (coordinate.equals(coordinateArray[0]) || coordinate.equals(coordinateArray[coordinateArray.length - 1]))) {
            return 1;
        }
        if (this.cga.isOnLine(coordinate, coordinateArray)) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate coordinate, LinearRing linearRing) {
        if (this.cga.isOnLine(coordinate, linearRing.getCoordinates())) {
            return 1;
        }
        if (this.cga.isPointInRing(coordinate, linearRing.getCoordinates())) {
            return 0;
        }
        return 2;
    }

    private int locate(Coordinate coordinate, Polygon polygon) {
        if (polygon.isEmpty()) {
            return 2;
        }
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        int n = this.locate(coordinate, linearRing);
        if (n == 2) {
            return 2;
        }
        if (n == 1) {
            return 1;
        }
        int n2 = 0;
        while (n2 < polygon.getNumInteriorRing()) {
            LinearRing linearRing2 = (LinearRing)polygon.getInteriorRingN(n2);
            int n3 = this.locate(coordinate, linearRing2);
            if (n3 == 0) {
                return 2;
            }
            if (n3 == 1) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }
}

