/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;

public abstract class LineIntersector {
    public static final int DONT_INTERSECT = 0;
    public static final int DO_INTERSECT = 1;
    public static final int COLLINEAR = 2;
    protected int result;
    protected Coordinate[][] inputLines = new Coordinate[2][2];
    protected Coordinate[] intPt = new Coordinate[2];
    protected int[][] intLineIndex;
    protected boolean isProper;
    protected Coordinate pa;
    protected Coordinate pb;
    protected PrecisionModel precisionModel = null;

    public static double computeEdgeDistance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = Math.abs(coordinate3.x - coordinate2.x);
        double d2 = Math.abs(coordinate3.y - coordinate2.y);
        double d3 = -1.0;
        d3 = coordinate.equals(coordinate2) ? 0.0 : (coordinate.equals(coordinate3) ? (d > d2 ? d : d2) : (d > d2 ? Math.abs(coordinate.x - coordinate2.x) : Math.abs(coordinate.y - coordinate2.y)));
        return d3;
    }

    public static double nonRobustComputeEdgeDistance(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate.x - coordinate2.x;
        double d2 = coordinate.y - coordinate2.y;
        double d3 = Math.sqrt(d * d + d2 * d2);
        Assert.isTrue(d3 != 0.0 || coordinate.equals(coordinate2), "Invalid distance calculation");
        return d3;
    }

    public LineIntersector() {
        this.intPt[0] = new Coordinate();
        this.intPt[1] = new Coordinate();
        this.pa = this.intPt[0];
        this.pb = this.intPt[1];
        this.result = 0;
    }

    public void setMakePrecise(PrecisionModel precisionModel) {
        this.precisionModel = precisionModel;
    }

    public abstract void computeIntersection(Coordinate var1, Coordinate var2, Coordinate var3);

    protected boolean isCollinear() {
        return this.result == 2;
    }

    public void computeIntersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        this.inputLines[0][0] = coordinate;
        this.inputLines[0][1] = coordinate2;
        this.inputLines[1][0] = coordinate3;
        this.inputLines[1][1] = coordinate4;
        this.result = this.computeIntersect(coordinate, coordinate2, coordinate3, coordinate4);
    }

    protected abstract int computeIntersect(Coordinate var1, Coordinate var2, Coordinate var3, Coordinate var4);

    public String toString() {
        String string = this.inputLines[0][0] + " " + this.inputLines[0][1] + " " + this.inputLines[1][0] + " " + this.inputLines[1][1] + " : ";
        if (this.isEndPoint()) {
            string = string + " endpoint";
        }
        if (this.isProper) {
            string = string + " proper";
        }
        if (this.isCollinear()) {
            string = string + " collinear";
        }
        return string;
    }

    protected boolean isEndPoint() {
        return this.hasIntersection() && !this.isProper;
    }

    public boolean hasIntersection() {
        return this.result != 0;
    }

    public int getIntersectionNum() {
        return this.result;
    }

    public Coordinate getIntersection(int n) {
        return this.intPt[n];
    }

    protected void computeIntLineIndex() {
        if (this.intLineIndex == null) {
            this.intLineIndex = new int[2][2];
            this.computeIntLineIndex(0);
            this.computeIntLineIndex(1);
        }
    }

    public boolean isIntersection(Coordinate coordinate) {
        int n = 0;
        while (n < this.result) {
            if (this.intPt[n].equals2D(coordinate)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isProper() {
        return this.hasIntersection() && this.isProper;
    }

    public Coordinate getIntersectionAlongSegment(int n, int n2) {
        this.computeIntLineIndex();
        return this.intPt[this.intLineIndex[n][n2]];
    }

    public int getIndexAlongSegment(int n, int n2) {
        this.computeIntLineIndex();
        return this.intLineIndex[n][n2];
    }

    protected void computeIntLineIndex(int n) {
        double d;
        double d2 = this.getEdgeDistance(n, 0);
        if (d2 > (d = this.getEdgeDistance(n, 1))) {
            this.intLineIndex[n][0] = 0;
            this.intLineIndex[n][1] = 1;
        } else {
            this.intLineIndex[n][0] = 1;
            this.intLineIndex[n][1] = 0;
        }
    }

    public double getEdgeDistance(int n, int n2) {
        double d = LineIntersector.computeEdgeDistance(this.intPt[n2], this.inputLines[n][0], this.inputLines[n][1]);
        return d;
    }
}

