/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class InteriorPointPoint {
    private Coordinate centroid;
    private double minDistance = Double.MAX_VALUE;
    private Coordinate interiorPoint = null;

    public InteriorPointPoint(Geometry geometry) {
        this.centroid = geometry.getCentroid().getCoordinate();
        this.add(geometry);
    }

    private void add(Geometry geometry) {
        if (geometry instanceof Point) {
            this.add(geometry.getCoordinate());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                this.add(geometryCollection.getGeometryN(n));
                ++n;
            }
        }
    }

    private void add(Coordinate coordinate) {
        double d = coordinate.distance(this.centroid);
        if (d < this.minDistance) {
            this.interiorPoint = new Coordinate(coordinate);
            this.minDistance = d;
        }
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }
}

