/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class InteriorPointArea {
    private GeometryFactory factory;
    private Coordinate interiorPoint = null;
    private double maxWidth = 0.0;

    private static double avg(double d, double d2) {
        return (d + d2) / 2.0;
    }

    public InteriorPointArea(Geometry geometry) {
        this.factory = new GeometryFactory(geometry.getPrecisionModel(), geometry.getSRID());
        this.add(geometry);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void add(Geometry geometry) {
        if (geometry instanceof Polygon) {
            this.addPolygon(geometry);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                this.add(geometryCollection.getGeometryN(n));
                ++n;
            }
        }
    }

    public void addPolygon(Geometry geometry) {
        LineString lineString = this.horizontalBisector(geometry);
        Geometry geometry2 = lineString.intersection(geometry);
        Geometry geometry3 = this.widestGeometry(geometry2);
        double d = geometry3.getEnvelopeInternal().getWidth();
        if (this.interiorPoint == null || d > this.maxWidth) {
            this.interiorPoint = this.centre(geometry3.getEnvelopeInternal());
            this.maxWidth = d;
        }
    }

    protected Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection geometryCollection) {
        if (geometryCollection.isEmpty()) {
            return geometryCollection;
        }
        Geometry geometry = geometryCollection.getGeometryN(0);
        int n = 1;
        while (n < geometryCollection.getNumGeometries()) {
            if (geometryCollection.getGeometryN(n).getEnvelopeInternal().getWidth() > geometry.getEnvelopeInternal().getWidth()) {
                geometry = geometryCollection.getGeometryN(n);
            }
            ++n;
        }
        return geometry;
    }

    protected LineString horizontalBisector(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double d = InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY());
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), d), new Coordinate(envelope.getMaxX(), d)});
    }

    public Coordinate centre(Envelope envelope) {
        return new Coordinate(InteriorPointArea.avg(envelope.getMinX(), envelope.getMaxX()), InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY()));
    }
}

