/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private PointLocator pointLocator = new PointLocator();
    private CGAlgorithms cgAlgorithms;
    private Geometry geometry;

    public ConvexHull(CGAlgorithms cGAlgorithms) {
        this.cgAlgorithms = cGAlgorithms;
    }

    public Geometry getConvexHull(Geometry geometry) {
        Coordinate[] coordinateArray;
        Object object;
        this.geometry = geometry;
        UniqueCoordinateArrayFilter uniqueCoordinateArrayFilter = new UniqueCoordinateArrayFilter();
        geometry.apply(uniqueCoordinateArrayFilter);
        Coordinate[] coordinateArray2 = uniqueCoordinateArrayFilter.getCoordinates();
        if (coordinateArray2.length == 0) {
            return new GeometryCollection(new Geometry[0], geometry.getPrecisionModel(), geometry.getSRID());
        }
        if (coordinateArray2.length == 1) {
            return new Point(coordinateArray2[0], geometry.getPrecisionModel(), geometry.getSRID());
        }
        if (coordinateArray2.length == 2) {
            return new LineString(coordinateArray2, geometry.getPrecisionModel(), geometry.getSRID());
        }
        if (coordinateArray2.length > 10) {
            object = this.reduce(coordinateArray2);
            coordinateArray = this.preSort((Coordinate[])object);
        } else {
            coordinateArray = this.preSort(coordinateArray2);
        }
        object = this.grahamScan(coordinateArray);
        Coordinate[] coordinateArray3 = this.toCoordinateArray((Stack)object);
        return this.lineOrPolygon(coordinateArray3);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinateArray = new Coordinate[stack.size()];
        int n = 0;
        while (n < stack.size()) {
            Coordinate coordinate;
            coordinateArray[n] = coordinate = (Coordinate)stack.get(n);
            ++n;
        }
        return coordinateArray;
    }

    private Coordinate[] reduce(Coordinate[] coordinateArray) {
        BigQuad bigQuad = this.bigQuad(coordinateArray);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(bigQuad.westmost);
        if (!arrayList.contains(bigQuad.northmost)) {
            arrayList.add(bigQuad.northmost);
        }
        if (!arrayList.contains(bigQuad.eastmost)) {
            arrayList.add(bigQuad.eastmost);
        }
        if (!arrayList.contains(bigQuad.southmost)) {
            arrayList.add(bigQuad.southmost);
        }
        if (arrayList.size() < 3) {
            return coordinateArray;
        }
        arrayList.add(bigQuad.westmost);
        Coordinate[] coordinateArray2 = new Coordinate[arrayList.size()];
        LinearRing linearRing = new LinearRing(arrayList.toArray(coordinateArray2), this.geometry.getPrecisionModel(), this.geometry.getSRID());
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>(arrayList);
        int n = 0;
        while (n < coordinateArray.length) {
            if (this.pointLocator.locate(coordinateArray[n], (Geometry)linearRing) == 2) {
                treeSet.add(coordinateArray[n]);
            }
            ++n;
        }
        Coordinate[] coordinateArray3 = treeSet.toArray(new Coordinate[0]);
        return coordinateArray3;
    }

    private Coordinate[] preSort(Coordinate[] coordinateArray) {
        int n = 1;
        while (n < coordinateArray.length) {
            if (coordinateArray[n].y < coordinateArray[0].y || coordinateArray[n].y == coordinateArray[0].y && coordinateArray[n].x < coordinateArray[0].x) {
                Coordinate coordinate = coordinateArray[0];
                coordinateArray[0] = coordinateArray[n];
                coordinateArray[n] = coordinate;
            }
            ++n;
        }
        this.radialSort(coordinateArray);
        return coordinateArray;
    }

    private Stack grahamScan(Coordinate[] coordinateArray) {
        Stack<Coordinate> stack = new Stack<Coordinate>();
        Coordinate coordinate = stack.push(coordinateArray[0]);
        coordinate = stack.push(coordinateArray[1]);
        coordinate = stack.push(coordinateArray[2]);
        int n = 3;
        while (n < coordinateArray.length) {
            coordinate = (Coordinate)stack.pop();
            while (this.cgAlgorithms.computeOrientation((Coordinate)stack.peek(), coordinate, coordinateArray[n]) > 0) {
                coordinate = (Coordinate)stack.pop();
            }
            coordinate = stack.push(coordinate);
            coordinate = stack.push(coordinateArray[n]);
            ++n;
        }
        coordinate = stack.push(coordinateArray[0]);
        return stack;
    }

    private void radialSort(Coordinate[] coordinateArray) {
        int n = 1;
        while (n < coordinateArray.length - 1) {
            int n2 = n;
            int n3 = n + 1;
            while (n3 < coordinateArray.length) {
                if (this.polarCompare(coordinateArray[0], coordinateArray[n3], coordinateArray[n2]) < 0) {
                    n2 = n3;
                }
                ++n3;
            }
            Coordinate coordinate = coordinateArray[n];
            coordinateArray[n] = coordinateArray[n2];
            coordinateArray[n2] = coordinate;
            ++n;
        }
    }

    private int polarCompare(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = coordinate3.y - coordinate.y;
        double d6 = Math.atan2(d2, d3);
        if (d6 < (d = Math.atan2(d4, d5))) {
            return -1;
        }
        if (d6 > d) {
            return 1;
        }
        double d7 = d2 * d2 + d3 * d3;
        double d8 = d4 * d4 + d5 * d5;
        if (d7 < d8) {
            return -1;
        }
        if (d7 > d8) {
            return 1;
        }
        return 0;
    }

    private boolean isBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (this.cgAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) != 0) {
            return false;
        }
        if (coordinate.x != coordinate3.x) {
            if (coordinate.x <= coordinate2.x && coordinate2.x <= coordinate3.x) {
                return true;
            }
            if (coordinate3.x <= coordinate2.x && coordinate2.x <= coordinate.x) {
                return true;
            }
        }
        if (coordinate.y != coordinate3.y) {
            if (coordinate.y <= coordinate2.y && coordinate2.y <= coordinate3.y) {
                return true;
            }
            if (coordinate3.y <= coordinate2.y && coordinate2.y <= coordinate.y) {
                return true;
            }
        }
        return false;
    }

    private BigQuad bigQuad(Coordinate[] coordinateArray) {
        BigQuad bigQuad = new BigQuad();
        bigQuad.northmost = coordinateArray[0];
        bigQuad.southmost = coordinateArray[0];
        bigQuad.westmost = coordinateArray[0];
        bigQuad.eastmost = coordinateArray[0];
        int n = 1;
        while (n < coordinateArray.length) {
            if (coordinateArray[n].x < bigQuad.westmost.x) {
                bigQuad.westmost = coordinateArray[n];
            }
            if (coordinateArray[n].x > bigQuad.eastmost.x) {
                bigQuad.eastmost = coordinateArray[n];
            }
            if (coordinateArray[n].y < bigQuad.southmost.y) {
                bigQuad.southmost = coordinateArray[n];
            }
            if (coordinateArray[n].y > bigQuad.northmost.y) {
                bigQuad.northmost = coordinateArray[n];
            }
            ++n;
        }
        return bigQuad;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinateArray) {
        if ((coordinateArray = this.cleanRing(coordinateArray)).length == 3) {
            return new LineString(new Coordinate[]{coordinateArray[0], coordinateArray[1]}, this.geometry.getPrecisionModel(), this.geometry.getSRID());
        }
        LinearRing linearRing = new LinearRing(coordinateArray, this.geometry.getPrecisionModel(), this.geometry.getSRID());
        return new Polygon(linearRing, this.geometry.getPrecisionModel(), this.geometry.getSRID());
    }

    private Coordinate[] cleanRing(Coordinate[] coordinateArray) {
        Coordinate[] coordinateArray2;
        Assert.equals(coordinateArray[0], coordinateArray[coordinateArray.length - 1]);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Coordinate[] coordinateArray3 = null;
        int n = 0;
        while (n <= coordinateArray.length - 2) {
            coordinateArray2 = coordinateArray[n];
            Coordinate coordinate = coordinateArray[n + 1];
            if (!(coordinateArray2.equals(coordinate) || coordinateArray3 != null && this.isBetween((Coordinate)coordinateArray3, (Coordinate)coordinateArray2, coordinate))) {
                arrayList.add(coordinateArray2);
                coordinateArray3 = coordinateArray2;
            }
            ++n;
        }
        arrayList.add(coordinateArray[coordinateArray.length - 1]);
        coordinateArray2 = new Coordinate[arrayList.size()];
        return arrayList.toArray(coordinateArray2);
    }

    private static class BigQuad {
        public Coordinate northmost;
        public Coordinate southmost;
        public Coordinate westmost;
        public Coordinate eastmost;

        private BigQuad() {
        }
    }
}

