/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Point;

public class CentroidPoint {
    private int ptCount = 0;
    private Coordinate centSum = new Coordinate();

    public void add(Geometry geometry) {
        if (geometry instanceof Point) {
            this.add(geometry.getCoordinate());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                this.add(geometryCollection.getGeometryN(n));
                ++n;
            }
        }
    }

    public void add(Coordinate coordinate) {
        ++this.ptCount;
        this.centSum.x += coordinate.x;
        this.centSum.y += coordinate.y;
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.centSum.x / (double)this.ptCount;
        coordinate.y = this.centSum.y / (double)this.ptCount;
        return coordinate;
    }
}

