/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;

public class CentroidLine {
    private Coordinate centSum = new Coordinate();
    private double totalLength = 0.0;

    public void add(Geometry geometry) {
        if (geometry instanceof LineString) {
            this.add(geometry.getCoordinates());
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                this.add(geometryCollection.getGeometryN(n));
                ++n;
            }
        }
    }

    public void add(Coordinate[] coordinateArray) {
        int n = 0;
        while (n < coordinateArray.length - 1) {
            double d = coordinateArray[n].distance(coordinateArray[n + 1]);
            this.totalLength += d;
            double d2 = (coordinateArray[n].x + coordinateArray[n + 1].x) / 2.0;
            this.centSum.x += d * d2;
            double d3 = (coordinateArray[n].y + coordinateArray[n + 1].y) / 2.0;
            this.centSum.y += d * d3;
            ++n;
        }
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.centSum.x / this.totalLength;
        coordinate.y = this.centSum.y / this.totalLength;
        return coordinate;
    }
}

