/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.Polygon;

public class CentroidArea {
    private CGAlgorithms cga = new RobustCGAlgorithms();
    private Coordinate basePt = null;
    private Coordinate triangleCent3 = new Coordinate();
    private double areasum2 = 0.0;
    private Coordinate cg3 = new Coordinate();

    public void add(Geometry geometry) {
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            this.setBasePoint(polygon.getCoordinates()[0]);
            this.add(polygon);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n = 0;
            while (n < geometryCollection.getNumGeometries()) {
                this.add(geometryCollection.getGeometryN(n));
                ++n;
            }
        }
    }

    public void add(Coordinate[] coordinateArray) {
        this.setBasePoint(coordinateArray[0]);
        this.addShell(coordinateArray);
    }

    public Coordinate getCentroid() {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.cg3.x / 3.0 / this.areasum2;
        coordinate.y = this.cg3.y / 3.0 / this.areasum2;
        return coordinate;
    }

    private void setBasePoint(Coordinate coordinate) {
        if (this.basePt == null) {
            this.basePt = coordinate;
        }
    }

    private void add(Polygon polygon) {
        this.addShell(polygon.getExteriorRing().getCoordinates());
        int n = 0;
        while (n < polygon.getNumInteriorRing()) {
            this.addHole(polygon.getInteriorRingN(n).getCoordinates());
            ++n;
        }
    }

    private void addShell(Coordinate[] coordinateArray) {
        boolean bl = !this.cga.isCCW(coordinateArray);
        int n = 0;
        while (n < coordinateArray.length - 1) {
            this.addTriangle(this.basePt, coordinateArray[n], coordinateArray[n + 1], bl);
            ++n;
        }
    }

    private void addHole(Coordinate[] coordinateArray) {
        boolean bl = this.cga.isCCW(coordinateArray);
        int n = 0;
        while (n < coordinateArray.length - 1) {
            this.addTriangle(this.basePt, coordinateArray[n], coordinateArray[n + 1], bl);
            ++n;
        }
    }

    private void addTriangle(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, boolean bl) {
        double d = bl ? 1.0 : -1.0;
        CentroidArea.centroid3(coordinate, coordinate2, coordinate3, this.triangleCent3);
        double d2 = CentroidArea.area2(coordinate, coordinate2, coordinate3);
        this.cg3.x += d * d2 * this.triangleCent3.x;
        this.cg3.y += d * d2 * this.triangleCent3.y;
        this.areasum2 += d * d2;
    }

    private static void centroid3(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) {
        coordinate4.x = coordinate.x + coordinate2.x + coordinate3.x;
        coordinate4.y = coordinate.y + coordinate2.y + coordinate3.y;
    }

    private static double area2(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        return (coordinate2.x - coordinate.x) * (coordinate3.y - coordinate.y) - (coordinate3.x - coordinate.x) * (coordinate2.y - coordinate.y);
    }
}

