/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.OutputStream;

public class EntryWriter {
    private OutputStream out = null;
    private String lineSeparator = null;
    private boolean err = false;

    public EntryWriter(OutputStream out) {
        this.out = out;
        this.lineSeparator = System.getProperty("line.separator");
    }

    public boolean error() {
        return this.err;
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.err = true;
        }
    }

    public void print(char c) {
        try {
            this.err = false;
            this.out.write(c);
        }
        catch (IOException e) {
            this.err = true;
        }
    }

    public void print(double d) {
        this.print(String.valueOf(d));
    }

    public void print(float f) {
        this.print(String.valueOf(f));
    }

    public void print(int i) {
        this.print(String.valueOf(i));
    }

    public void print(long l) {
        this.print(String.valueOf(l));
    }

    public void print(String s) {
        try {
            this.err = false;
            if (s != null) {
                int i = 0;
                while (i < s.length()) {
                    this.out.write(s.charAt(i));
                    ++i;
                }
            }
        }
        catch (IOException e) {
            this.err = true;
        }
    }

    public void print(short s) {
        this.print(String.valueOf(s));
    }

    public void println() {
        this.print(this.lineSeparator);
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.err = true;
        }
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(short s) {
        this.print(s);
        this.println();
    }

    public void writeByte(int b) {
        char c = (char)(b & 0xFF);
        this.print(c);
    }

    public void writeWord2(int w) {
        char c = (char)(w >> 8 & 0xFF);
        this.print(c);
        c = (char)(w & 0xFF);
        this.print(c);
    }

    public void writeWord4(int w) {
        char c = (char)(w >> 24 & 0xFF);
        this.print(c);
        c = (char)(w >> 16 & 0xFF);
        this.print(c);
        c = (char)(w >> 8 & 0xFF);
        this.print(c);
        c = (char)(w & 0xFF);
        this.print(c);
    }
}

