/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import util.DupHashtableEntry;
import util.DupHashtableEnumerator;

public class DupHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private transient DupHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;
    private DupHashtableEntry lastFoundEntry;

    public DupHashtable() {
        this(101, 0.75f);
    }

    public DupHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public DupHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new DupHashtableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public synchronized void clear() {
        DupHashtableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public synchronized Object clone() {
        try {
            DupHashtable t = (DupHashtable)super.clone();
            t.table = new DupHashtableEntry[this.table.length];
            int i = this.table.length;
            while (i-- > 0) {
                DupHashtableEntry dupHashtableEntry = t.table[i] = this.table[i] != null ? (DupHashtableEntry)this.table[i].clone() : null;
            }
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public synchronized boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        DupHashtableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            DupHashtableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(Object key) {
        DupHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        DupHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Enumeration elements() {
        return new DupHashtableEnumerator(this.table, false);
    }

    public synchronized Object get(Object key) {
        DupHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        DupHashtableEntry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                this.lastFoundEntry = e;
                return e.value;
            }
            e = e.next;
        }
        this.lastFoundEntry = null;
        return null;
    }

    public synchronized Object getNext(Object key) {
        if (this.lastFoundEntry == null) {
            return null;
        }
        int hash = key.hashCode();
        DupHashtableEntry e = this.lastFoundEntry.next;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                this.lastFoundEntry = e;
                return e.value;
            }
            e = e.next;
        }
        this.lastFoundEntry = null;
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized Enumeration keys() {
        return new DupHashtableEnumerator(this.table, true);
    }

    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(key, value);
        }
        DupHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        DupHashtableEntry e = new DupHashtableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = null;
        if (tab[index] == null) {
            tab[index] = e;
        } else {
            DupHashtableEntry actEntry = tab[index];
            while (actEntry.next != null) {
                actEntry = actEntry.next;
            }
            actEntry.next = e;
        }
        ++this.count;
        return value;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        DupHashtableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        DupHashtableEntry[] newTable = new DupHashtableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            DupHashtableEntry old = oldTable[i];
            while (old != null) {
                DupHashtableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized Object remove(Object key) {
        DupHashtableEntry[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        DupHashtableEntry e = tab[index];
        DupHashtableEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.count;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration k = this.keys();
        Enumeration e = this.elements();
        buf.append("{");
        int i = 0;
        while (i <= max) {
            String s1 = k.nextElement().toString();
            String s2 = e.nextElement().toString();
            buf.append(String.valueOf(s1) + "=" + s2);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }
}

