/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.IOException;
import java.io.InputStream;
import util.EntryInput;

public class DataReader
implements EntryInput {
    private InputStream in = null;
    private char[] buffer = null;
    private final int maxBufferSize = 8192;
    private int bi = 0;
    private boolean eol = false;
    private boolean eof = false;
    private boolean numErr = false;
    private int nextEntryLength = 0;
    private char terminatingChar = (char)9;

    public DataReader(InputStream in) {
        this.in = in;
        this.buffer = new char[8192];
    }

    public boolean eof() {
        return this.eof;
    }

    public boolean eol() {
        return this.eol;
    }

    public boolean numErr() {
        return this.numErr;
    }

    public boolean readBoolean() {
        char c = this.readChar();
        return c == '1';
    }

    public char readChar() {
        int c = 0;
        try {
            c = this.in.read();
            if (c < 0) {
                c = 0;
                this.eof = true;
            }
            this.eol = c == 10 || c == 13;
            return (char)c;
        }
        catch (IOException io) {
            this.eof = true;
            return (char)c;
        }
    }

    public double readDouble() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Double(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0.0;
            }
        }
        this.numErr = true;
        return 0.0;
    }

    public int readInt() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Integer(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0;
            }
        }
        this.numErr = true;
        return 0;
    }

    public long readLong() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Long(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0L;
            }
        }
        this.numErr = true;
        return 0L;
    }

    public short readShort() {
        String s = this.readString();
        this.numErr = false;
        if (s != null) {
            try {
                return new Short(s.replace('+', ' ').trim());
            }
            catch (NumberFormatException nfe) {
                this.numErr = true;
                return 0;
            }
        }
        this.numErr = true;
        return 0;
    }

    public String readString() {
        try {
            int c;
            while (this.bi < 8192 && (this.bi <= 0 || this.bi != this.nextEntryLength)) {
                c = this.in.read();
                if (c < 0) {
                    this.buffer[this.bi] = 32;
                    this.eof = true;
                    break;
                }
                this.buffer[this.bi] = (char)c;
                if (this.buffer[this.bi] == '\n' || this.buffer[this.bi] == '\r' || this.buffer[this.bi] == this.terminatingChar) break;
                ++this.bi;
            }
            this.eol = this.buffer[this.bi] == '\n' || this.buffer[this.bi] == '\r';
            int bi1 = this.bi;
            this.bi = 0;
            if (!this.eof && bi1 < 8192 && this.buffer[bi1] == '\r' && (char)(c = this.in.read()) != '\n') {
                String s = new String(this.buffer, 0, bi1);
                this.buffer[0] = (char)c;
                this.bi = 1;
                return s;
            }
            if (!this.eof || bi1 > 0) {
                return new String(this.buffer, 0, bi1);
            }
            return null;
        }
        catch (IOException io) {
            this.eof = true;
            if (this.bi > 0) {
                return new String(this.buffer, 0, this.bi);
            }
            return null;
        }
    }

    public short readWord2() {
        char ch1 = this.readChar();
        char ch2 = this.readChar();
        return (short)((ch1 << 8) + (ch2 << 0));
    }

    public int readWord4() {
        char ch1 = this.readChar();
        char ch2 = this.readChar();
        char ch3 = this.readChar();
        char ch4 = this.readChar();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public void setNextEntryLength(int length) {
        this.nextEntryLength = length;
    }

    public void setTerminatingChar(char t) {
        this.terminatingChar = t;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

