/*
 * Decompiled with CFR 0.152.
 */
package spatialdb;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleConnection;
import oracle.sdoapi.OraSpatialManager;
import oracle.sdoapi.adapter.GeometryAdapter;
import oracle.sdoapi.adapter.GeometryOutputTypeNotSupportedException;
import oracle.sdoapi.geom.CurvePolygon;
import oracle.sdoapi.geom.Geometry;
import oracle.sdoapi.geom.GeometryFactory;
import oracle.sdoapi.geom.InvalidGeometryException;
import oracle.sdoapi.geom.LineString;
import oracle.sdoapi.geom.Point;
import oracle.sdoapi.geom.Polygon;
import spatialdb.DefaultGeometryFactory;
import spatialdb.SpatialResultSet;

public class PreparedSpatialStatement
implements PreparedStatement {
    private PreparedStatement s;
    private GeometryFactory gf;
    private GeometryAdapter adapter;
    public int CLOSE_CURRENT_RESULT = 1;
    public int KEEP_CURRENT_RESULT = 2;
    public int CLOSE_ALL_RESULTS = 3;
    public int SUCCESS_NO_INFO = -2;
    public int EXECUTE_FAILED = -3;
    public int RETURN_GENERATED_KEYS = 1;
    public int NO_GENERATED_KEYS = 2;
    static /* synthetic */ Class class$0;

    public PreparedSpatialStatement(PreparedStatement prepStmt) throws SQLException {
        this.s = prepStmt;
        this.gf = DefaultGeometryFactory.getFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("oracle.sql.STRUCT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.adapter = OraSpatialManager.getGeometryAdapter((String)"SDO", (String)"8.1.6", null, clazz, null, (OracleConnection)((OracleConnection)this.s.getConnection()));
    }

    public void addBatch() throws SQLException {
        this.s.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.s.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.s.cancel();
    }

    public void clearBatch() throws SQLException {
        this.s.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this.s.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.s.clearWarnings();
    }

    public void close() throws SQLException {
        this.s.close();
    }

    public boolean execute() throws SQLException {
        return this.s.execute();
    }

    public boolean execute(String sql) throws SQLException {
        return this.s.execute(sql);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        System.err.println("PreparedSpatialStatement.execute(String,int[]) is not implemented!");
        return false;
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        System.err.println("PreparedSpatialStatement.execute(String,String[]) is not implemented!");
        return false;
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println("PreparedSpatialStatement.execute(String,int) is not implemented!");
        return false;
    }

    public int[] executeBatch() throws SQLException {
        return this.s.executeBatch();
    }

    public ResultSet executeQuery() throws SQLException {
        return SpatialResultSet.newSet(this.s.executeQuery(), this.s.getConnection());
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return SpatialResultSet.newSet(this.s.executeQuery(sql), this.s.getConnection());
    }

    public int executeUpdate() throws SQLException {
        return this.s.executeUpdate();
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.s.executeUpdate(sql);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        System.err.println("PreparedSpatialStatement.executeUpdate(String,int[]) is not implemented!");
        return 0;
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        System.err.println("PreparedSpatialStatement.executeUpdate(String,String[]) is not implemented!");
        return 0;
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        System.err.println("PreparedSpatialStatement.executeUpdate(String,int) is not implemented!");
        return 0;
    }

    public Connection getConnection() throws SQLException {
        return this.s.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.s.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.s.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        System.err.println("PreparedSpatialStatement.getGeneratedKeys() is not implemented!");
        return null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.s.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.s.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.s.getMetaData();
    }

    public boolean getMoreResults() throws SQLException {
        return this.s.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        System.err.println("PreparedSpatialStatement.getMoreResults(int) is not implemented!");
        return false;
    }

    public int getQueryTimeout() throws SQLException {
        return this.s.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return SpatialResultSet.newSet(this.s.getResultSet(), this.s.getConnection());
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.s.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        System.err.println("PreparedSpatialStatement.getResultSetHoldability() is not implemented!");
        return 0;
    }

    public int getResultSetType() throws SQLException {
        return this.s.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.s.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.s.getWarnings();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.s.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.s.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.s.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.s.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.s.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.s.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.s.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.s.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.s.setCharacterStream(parameterIndex, reader, length);
    }

    public void setCircle(int index, double x, double y, double radius) throws SQLException {
        try {
            CurvePolygon circle = this.gf.createCircle(x, y, radius);
            this.setGeometry(index, (Geometry)circle);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.s.setClob(i, x);
    }

    public void setCursorName(String name) throws SQLException {
        this.s.setCursorName(name);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.s.setDate(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.s.setDate(parameterIndex, x, cal);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.s.setDouble(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.s.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.s.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.s.setFetchSize(rows);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.s.setFloat(parameterIndex, x);
    }

    public void setGeometry(int index, Geometry geometry) throws SQLException {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("oracle.sql.STRUCT");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.s.setObject(index, this.adapter.exportGeometry((Class)clazz, geometry));
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
        catch (GeometryOutputTypeNotSupportedException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.s.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.s.setLong(parameterIndex, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.s.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.s.setMaxRows(max);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.s.setNull(parameterIndex, sqlType);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.s.setNull(paramIndex, sqlType, typeName);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.s.setObject(parameterIndex, x);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.s.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.s.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setPoint(int index, double x, double y) throws SQLException {
        try {
            Point point = this.gf.createPoint(x, y);
            this.setGeometry(index, (Geometry)point);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setPolygon(int index, double[] x, double[] y, int n) throws SQLException {
        if (x == null || y == null) {
            throw new SQLException("x- or y-array is not set");
        }
        if (x.length < n || y.length < n) {
            throw new SQLException("x- or y-array too small");
        }
        try {
            double[] points = new double[2 * n];
            int i = 0;
            while (i < n) {
                points[2 * i] = x[i];
                points[2 * i + 1] = y[i];
                ++i;
            }
            Polygon polygon = this.gf.createPolygon(this.gf.createLineString(points), null);
            this.setGeometry(index, (Geometry)polygon);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setPolygon(int index, int[] x, int[] y, int n) throws SQLException {
        if (x == null || y == null) {
            throw new SQLException("x- or y-array is not set");
        }
        if (x.length < n || y.length < n) {
            throw new SQLException("x- or y-array too small");
        }
        try {
            double[] points = new double[2 * n];
            int i = 0;
            while (i < n) {
                points[2 * i] = x[i];
                points[2 * i + 1] = y[i];
                ++i;
            }
            Polygon polygon = this.gf.createPolygon(this.gf.createLineString(points), null);
            this.setGeometry(index, (Geometry)polygon);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setPolyline(int index, double[] x, double[] y, int n) throws SQLException {
        if (x == null || y == null) {
            throw new SQLException("x- or y-array is not set");
        }
        if (x.length < n || y.length < n) {
            throw new SQLException("x- or y-array too small");
        }
        try {
            double[] points = new double[2 * n];
            int i = 0;
            while (i < n) {
                points[2 * i] = x[i];
                points[2 * i + 1] = y[i];
                ++i;
            }
            LineString line = this.gf.createLineString(points);
            this.setGeometry(index, (Geometry)line);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setPolyline(int index, int[] x, int[] y, int n) throws SQLException {
        if (x == null || y == null) {
            throw new SQLException("x- or y-array is not set");
        }
        if (x.length < n || y.length < n) {
            throw new SQLException("x- or y-array too small");
        }
        try {
            double[] points = new double[2 * n];
            int i = 0;
            while (i < n) {
                points[2 * i] = x[i];
                points[2 * i + 1] = y[i];
                ++i;
            }
            LineString line = this.gf.createLineString(points);
            this.setGeometry(index, (Geometry)line);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.s.setQueryTimeout(seconds);
    }

    public void setRectangle(int index, double xmin, double ymin, double xmax, double ymax) throws SQLException {
        try {
            Polygon rect = this.gf.createRectangle(Math.min(xmin, xmax), Math.min(ymin, ymax), Math.max(xmin, xmax), Math.max(ymin, ymax));
            this.setGeometry(index, (Geometry)rect);
        }
        catch (InvalidGeometryException e) {
            throw new SQLException(e.toString());
        }
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.s.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.s.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.s.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.s.setTime(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.s.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.s.setTimestamp(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.s.setTimestamp(parameterIndex, x, cal);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        System.err.println("PreparedSpatialStatement.setUnicodeStream(int,InputStream,int) is not implemented!");
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        System.err.println("PreparedSpatialStatement.setURL(int,URL) is not implemented!");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        System.err.println("PreparedSpatialStatement.getParameterMetaData() is not implemented!");
        return null;
    }
}

