/*
 * Decompiled with CFR 0.152.
 */
package spatialdb;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Enumeration;
import java.util.Vector;
import oracle.sdoapi.geom.CoordPoint;
import oracle.sdoapi.geom.CurveString;
import oracle.sdoapi.geom.Geometry;
import oracle.sdoapi.geom.GeometryCollection;
import oracle.sdoapi.geom.GeometryFactory;
import oracle.sdoapi.geom.LineString;
import oracle.sdoapi.geom.MultiLineString;
import oracle.sdoapi.geom.MultiPoint;
import oracle.sdoapi.geom.MultiPolygon;
import oracle.sdoapi.geom.Point;
import oracle.sdoapi.geom.Polygon;
import oracle.sdoapi.sref.SpatialReference;

public class GeometryConversion {
    private static GeometryFactory gf;

    private static GeneralPath fromCurveStringToAwtGeneralPath(CurveString line, AffineTransform matrix) {
        LineString r = (LineString)line;
        int n = r.getNumPoints();
        GeneralPath path = new GeneralPath(1, n);
        CoordPoint cp = r.getPointAt(0);
        Point2D.Double pl = new Point2D.Double(cp.getX(), cp.getY());
        int i = 1;
        while (i < n) {
            cp = r.getPointAt(i);
            Point2D.Double p = new Point2D.Double(cp.getX(), cp.getY());
            Line2D.Double seg = new Line2D.Double(pl, p);
            path.append(seg, true);
            pl = p;
            ++i;
        }
        if (matrix != null) {
            path.transform(matrix);
        }
        return path;
    }

    private static java.awt.Polygon fromCurveStringToAwtPolygon(CurveString line, AffineTransform matrix) {
        if (line == null) {
            return null;
        }
        int n = line.getNumPoints();
        int[] x = new int[n];
        int[] y = new int[n];
        int i = 0;
        while (i < n) {
            CoordPoint p = line.getPointAt(i);
            Point2D.Double p2d = new Point2D.Double(p.getX(), p.getY());
            if (matrix != null) {
                matrix.transform(p2d, p2d);
            }
            x[i] = (int)Math.round(((Point2D)p2d).getX());
            y[i] = (int)Math.round(((Point2D)p2d).getY());
            ++i;
        }
        return new java.awt.Polygon(x, y, n);
    }

    private static String fromGeometryCollectionToXML(GeometryCollection gc, String indentation) {
        SpatialReference srs = gc.getSpatialReference();
        if (srs == null) {
            return String.valueOf(indentation) + "<MultiGeometryError>spatial reference is required</MultiGeometryError>\n";
        }
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<MultiGeometry srsName=\"" + srs.getName() + "\">\n");
        Enumeration g = gc.getGeometries();
        while (g.hasMoreElements()) {
            strBuf.append(String.valueOf(indentation) + " <geometryMember>\n");
            strBuf.append(GeometryConversion.toXML((Geometry)g.nextElement(), String.valueOf(indentation) + "  "));
            strBuf.append(" </geometryMember>\n");
        }
        strBuf.append(String.valueOf(indentation) + "</MultiGeometry>\n");
        return strBuf.toString();
    }

    private static String fromLinearRingToXML(LineString ls, String indentation) {
        double[] xArray = ls.getOrdArray(0);
        double[] yArray = ls.getOrdArray(1);
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<LinearRing>");
        int i = 0;
        while (i < xArray.length) {
            strBuf.append(GeometryConversion.toXML(xArray[i], yArray[i]));
            ++i;
        }
        strBuf.append("</LinearRing>");
        return strBuf.toString();
    }

    private static String fromLineStringToXML(LineString ls, String indentation) {
        double[] xArray = ls.getOrdArray(0);
        double[] yArray = ls.getOrdArray(1);
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<LineString>");
        int i = 0;
        while (i < xArray.length) {
            strBuf.append(GeometryConversion.toXML(xArray[i], yArray[i]));
            ++i;
        }
        strBuf.append("</LineString>");
        return strBuf.toString();
    }

    private static String fromMultiLineStringToXML(MultiLineString mls, String indentation) {
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<MultiLineString>\n");
        Enumeration ls = mls.getGeometries();
        while (ls.hasMoreElements()) {
            strBuf.append(String.valueOf(indentation) + "  <lineStringMember> ");
            strBuf.append(GeometryConversion.fromLineStringToXML((LineString)ls.nextElement(), String.valueOf(indentation) + "  "));
            strBuf.append(" </lineStringMember>\n");
        }
        strBuf.append(String.valueOf(indentation) + "</MultiLineString>\n");
        return strBuf.toString();
    }

    private static String fromMultiPointToXML(MultiPoint mp, String indentation) {
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<MultiPoint>\n");
        Enumeration p = mp.getGeometries();
        while (p.hasMoreElements()) {
            strBuf.append(String.valueOf(indentation) + "  <pointMember> ");
            strBuf.append(GeometryConversion.fromPointToXML((Point)p.nextElement(), ""));
            strBuf.append(" </pointMember>\n");
        }
        strBuf.append(String.valueOf(indentation) + "</MultiPoint>\n");
        return strBuf.toString();
    }

    private static String fromMultiPolygonToXML(MultiPolygon mpg, String indentation) {
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<MultiPolygon>\n");
        Enumeration pg = mpg.getGeometries();
        while (pg.hasMoreElements()) {
            strBuf.append(String.valueOf(indentation) + " <polygonMember>\n");
            strBuf.append(GeometryConversion.fromPolygonToXML((Polygon)pg.nextElement(), String.valueOf(indentation) + "  "));
            strBuf.append(" </polygonMember>\n");
        }
        strBuf.append(String.valueOf(indentation) + "</MultiPolygon>\n");
        return strBuf.toString();
    }

    private static String fromPointToXML(Point p, String indentation) {
        return new String(String.valueOf(indentation) + "<Point>" + GeometryConversion.toXML(p.getX(), p.getY()) + "</Point>");
    }

    private static String fromPolygonToXML(Polygon pg, String indentation) {
        StringBuffer strBuf = new StringBuffer(String.valueOf(indentation) + "<Polygon>\n" + indentation + " <outerBoundaryIs>\n");
        LineString ring = (LineString)pg.getExteriorRing();
        strBuf.append(GeometryConversion.fromLinearRingToXML(ring, String.valueOf(indentation) + "  "));
        strBuf.append("\n" + indentation + " </outerBoundaryIs>\n");
        if (pg.getNumRings() > 1) {
            strBuf.append(String.valueOf(indentation) + " <innerBoundaryIs>\n");
            Enumeration e = pg.getInteriorRings();
            while (e.hasMoreElements()) {
                strBuf.append(GeometryConversion.fromLinearRingToXML((LineString)e.nextElement(), String.valueOf(indentation) + "  "));
                strBuf.append("\n");
            }
            strBuf.append(String.valueOf(indentation) + " </innerBoundaryIs>\n");
        }
        strBuf.append(String.valueOf(indentation) + "</Polygon>\n");
        return strBuf.toString();
    }

    public static Area toAwtArea(Geometry polygon) {
        return GeometryConversion.toAwtArea(polygon, null);
    }

    public static Area toAwtArea(Geometry polygon, AffineTransform matrix) {
        Polygon pol = (Polygon)polygon;
        CurveString r = pol.getExteriorRing();
        Area result = new Area(GeometryConversion.fromCurveStringToAwtGeneralPath(r, matrix));
        int i = 1;
        while (i < pol.getNumRings()) {
            r = pol.getRingAt(i);
            result.subtract(new Area(GeometryConversion.fromCurveStringToAwtGeneralPath(r, matrix)));
            ++i;
        }
        return result;
    }

    public static Ellipse2D.Double toAwtEllipse2D(Geometry geometry, int pixels) {
        return GeometryConversion.toAwtEllipse2D(geometry, null, pixels);
    }

    public static Ellipse2D.Double toAwtEllipse2D(Geometry geometry, AffineTransform matrix, int pixels) {
        try {
            Point2D.Double p = new Point2D.Double(((Point)geometry).getX(), ((Point)geometry).getY());
            p = matrix == null ? p : (Point2D.Double)matrix.transform(p, p);
            Ellipse2D.Double circle = new Ellipse2D.Double(p.getX() - (double)pixels, p.getY() - (double)pixels, 2 * pixels, 2 * pixels);
            return circle;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static GeneralPath toAwtGeneralPath(Geometry line) {
        return GeometryConversion.toAwtGeneralPath(line, null);
    }

    public static GeneralPath toAwtGeneralPath(Geometry line, AffineTransform matrix) {
        return GeometryConversion.fromCurveStringToAwtGeneralPath((CurveString)((LineString)line), matrix);
    }

    public static java.awt.Point toAwtPoint(Geometry geometry) {
        return GeometryConversion.toAwtPoint(geometry, null);
    }

    public static java.awt.Point toAwtPoint(Geometry geometry, AffineTransform matrix) {
        Point2D.Double p = GeometryConversion.toAwtPoint2D(geometry, matrix);
        if (p == null) {
            return null;
        }
        return new java.awt.Point((int)Math.round(((Point2D)p).getX()), (int)Math.round(((Point2D)p).getY()));
    }

    public static Point2D.Double toAwtPoint2D(Geometry geometry) {
        return GeometryConversion.toAwtPoint2D(geometry, null);
    }

    public static Point2D.Double toAwtPoint2D(Geometry geometry, AffineTransform matrix) {
        if (geometry == null) {
            return null;
        }
        Point2D.Double p = new Point2D.Double(((Point)geometry).getX(), ((Point)geometry).getY());
        return matrix == null ? p : (Point2D.Double)matrix.transform(p, p);
    }

    public static java.awt.Polygon toAwtPolygon(Geometry geometry) {
        return GeometryConversion.toAwtPolygon(geometry, null);
    }

    public static java.awt.Polygon toAwtPolygon(Geometry geometry, AffineTransform matrix) {
        if (geometry == null) {
            return null;
        }
        return GeometryConversion.fromCurveStringToAwtPolygon(((Polygon)geometry).getExteriorRing(), matrix);
    }

    public static java.awt.Polygon toAwtPolyline(Geometry geometry) {
        return GeometryConversion.toAwtPolyline(geometry, null);
    }

    public static java.awt.Polygon toAwtPolyline(Geometry geometry, AffineTransform matrix) {
        return GeometryConversion.fromCurveStringToAwtPolygon((CurveString)((LineString)geometry), matrix);
    }

    public static Rectangle toAwtRectangle(Geometry geometry) {
        return GeometryConversion.toAwtRectangle(geometry, null);
    }

    public static Rectangle toAwtRectangle(Geometry geometry, AffineTransform matrix) {
        Rectangle2D.Double r = GeometryConversion.toAwtRectangle2D(geometry, matrix);
        if (r == null) {
            return null;
        }
        return new Rectangle((int)Math.round(((RectangularShape)r).getX()), (int)Math.round(((RectangularShape)r).getY()), (int)Math.round(((RectangularShape)r).getWidth()), (int)Math.round(((RectangularShape)r).getHeight()));
    }

    public static Rectangle2D.Double toAwtRectangle2D(Geometry geometry) {
        return GeometryConversion.toAwtRectangle2D(geometry, null);
    }

    public static Rectangle2D.Double toAwtRectangle2D(Geometry geometry, AffineTransform matrix) {
        if (geometry == null) {
            return null;
        }
        CurveString ring = ((Polygon)geometry).getExteriorRing();
        CoordPoint p1 = ring.getPointAt(0);
        CoordPoint p2 = ring.getPointAt(2);
        if (matrix == null) {
            return new Rectangle2D.Double(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.abs(p1.getX() - p2.getX()), Math.abs(p1.getY() - p2.getY()));
        }
        Point2D.Double p2d1 = new Point2D.Double(p1.getX(), p1.getY());
        Point2D.Double p2d2 = new Point2D.Double(p2.getX(), p2.getY());
        matrix.transform(p2d1, p2d1);
        matrix.transform(p2d2, p2d2);
        return new Rectangle2D.Double(Math.min(((Point2D)p2d1).getX(), ((Point2D)p2d2).getX()), Math.min(((Point2D)p2d1).getY(), ((Point2D)p2d2).getY()), Math.abs(((Point2D)p2d1).getX() - ((Point2D)p2d2).getX()), Math.abs(((Point2D)p2d1).getY() - ((Point2D)p2d2).getY()));
    }

    public static Vector toAwtShape(Geometry geom) {
        return GeometryConversion.toAwtShape(geom, null);
    }

    public static Vector toAwtShape(Geometry geom, AffineTransform matrix) {
        Vector<Shape> result = new Vector<Shape>(5);
        if (geom instanceof Point) {
            result.add(GeometryConversion.toAwtEllipse2D(geom, matrix, 3));
        } else if (geom instanceof LineString) {
            result.add(GeometryConversion.toAwtGeneralPath(geom, matrix));
        } else if (geom instanceof Polygon) {
            result.add(GeometryConversion.toAwtArea(geom, matrix));
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection coll = (GeometryCollection)geom;
            int i = 0;
            while (i < coll.getNumGeometries()) {
                result.addAll(GeometryConversion.toAwtShape(coll.getGeometryAt(i), matrix));
                ++i;
            }
        }
        return result;
    }

    public static Object toDoubleAwt(Geometry geom) {
        return GeometryConversion.toIntegerAwt(geom, null);
    }

    public static Object toDoubleAwt(Geometry geom, AffineTransform matrix) {
        if (geom instanceof Point) {
            return GeometryConversion.toAwtPoint2D(geom, matrix);
        }
        if (geom instanceof LineString) {
            return GeometryConversion.toAwtGeneralPath(geom, matrix);
        }
        if (geom instanceof Polygon) {
            return GeometryConversion.toAwtArea(geom, matrix);
        }
        return null;
    }

    public static Object toIntegerAwt(Geometry geom) {
        return GeometryConversion.toIntegerAwt(geom, null);
    }

    public static Object toIntegerAwt(Geometry geom, AffineTransform matrix) {
        if (geom instanceof Point) {
            return GeometryConversion.toAwtPoint(geom, matrix);
        }
        if (geom instanceof LineString) {
            return GeometryConversion.toAwtPolyline(geom, matrix);
        }
        if (geom instanceof Polygon) {
            return GeometryConversion.toAwtPolyline(geom, matrix);
        }
        return null;
    }

    public static String toXML(double x, double y) {
        return "<coord><X>" + x + "</X><Y>" + y + "</Y></coord>";
    }

    public static String toXML(double xmin, double ymin, double xmax, double ymax) {
        return "<Box>" + GeometryConversion.toXML(xmin, ymin) + GeometryConversion.toXML(xmax, ymax) + "</Box>";
    }

    public static String toXML(Geometry geom) {
        return GeometryConversion.toXML(geom, "");
    }

    public static String toXML(Geometry geom, String indentation) {
        if (geom instanceof Point) {
            return GeometryConversion.fromPointToXML((Point)geom, indentation);
        }
        if (geom instanceof LineString) {
            return GeometryConversion.fromLineStringToXML((LineString)geom, indentation);
        }
        if (geom instanceof Polygon) {
            return GeometryConversion.fromPolygonToXML((Polygon)geom, String.valueOf(indentation) + "");
        }
        if (geom instanceof MultiPolygon) {
            return GeometryConversion.fromMultiPolygonToXML((MultiPolygon)geom, indentation);
        }
        if (geom instanceof MultiLineString) {
            return GeometryConversion.fromMultiLineStringToXML((MultiLineString)geom, indentation);
        }
        if (geom instanceof MultiPoint) {
            return GeometryConversion.fromMultiPointToXML((MultiPoint)geom, indentation);
        }
        if (geom instanceof GeometryCollection) {
            return GeometryConversion.fromGeometryCollectionToXML((GeometryCollection)geom, indentation);
        }
        return String.valueOf(indentation) + "<GeometryError>" + geom.getClass().getName() + " is not supported yet</GeometryError>";
    }
}

