/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import index.Query;
import spatial.MBR;
import spatial.SpatialQuery;
import spatial.SpatialSearchTree;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeNode;
import spatial.SpatialSearchTreeObject;
import spatial.SpatialSearchTreeQuery;

public class RegionQuery
extends Query
implements SpatialSearchTreeQuery {
    protected SpatialQuery query = null;
    protected SpatialSearchTreeObject queryObj;
    protected MBR rect;
    protected int operation = 0;
    protected static final int MAXHEIGHT = 40;
    protected SpatialSearchTreeNode[] node = new SpatialSearchTreeNode[40];
    protected int[] index = new int[40];
    protected int pathLength = 0;

    public RegionQuery(SpatialQuery query) {
        this.node[0] = null;
        this.query = query;
    }

    public SpatialSearchTreeObject getNextObject() {
        if (this.node[0] != null) {
            this.timer.start();
            SpatialSearchTreeObject obj = this.getNextObject(0);
            if (obj == null) {
                this.reset();
            } else {
                ++this.resultNum;
            }
            this.timer.stop();
            return obj;
        }
        return null;
    }

    protected SpatialSearchTreeObject getNextObject(int actHeight) {
        if (actHeight == this.pathLength) {
            this.node[this.pathLength] = this.node[this.pathLength - 1].getChildNode(this.index[this.pathLength - 1]);
            this.index[this.pathLength] = 0;
            ++this.pathLength;
        }
        int num = this.node[actHeight].getNumberOfEntries();
        if (this.node[actHeight].isLeaf()) {
            int i = this.index[actHeight];
            while (i < num) {
                SpatialSearchTreeObject obj;
                SpatialSearchTreeEntry entry = this.node[actHeight].getEntry(i);
                if (this.query.conditionFulfilled(this.rect, entry) && this.query.conditionFulfilled(this.rect, obj = this.node[actHeight].getObject(i))) {
                    if (this.operation == 0) {
                        this.index[actHeight] = i + 1;
                        return obj;
                    }
                    if (this.operation == 2) {
                        this.node[actHeight].removeObject(i);
                        --i;
                        --num;
                    } else if (this.operation == 1) {
                        if (this.query.areEqual(this.queryObj, obj)) {
                            this.node[actHeight].removeObject(i);
                            this.index[actHeight] = i;
                            return obj;
                        }
                    } else if (this.operation == 6) {
                        this.node[actHeight].updateObject(i);
                    } else if (this.operation == 5 && this.query.areEqual(this.queryObj, obj)) {
                        this.node[actHeight].updateObject(i);
                        return obj;
                    }
                }
                ++i;
            }
        } else {
            int i = this.index[actHeight];
            while (i < num) {
                if (actHeight + 1 < this.pathLength || this.query.conditionFulfilled(this.rect, this.node[actHeight].getEntryMBR(i))) {
                    this.index[actHeight] = i;
                    SpatialSearchTreeObject res = this.getNextObject(actHeight + 1);
                    if (res != null) {
                        return res;
                    }
                }
                ++i;
            }
        }
        --this.pathLength;
        if (!this.node[this.pathLength].isRoot()) {
            this.node[this.pathLength].resetLock();
        }
        return null;
    }

    public SpatialQuery getQuery() {
        return this.query;
    }

    public void init(SpatialSearchTree tree) {
        this.init(tree, 0);
    }

    public void init(SpatialSearchTree tree, int operation) {
        this.initWithRect(tree, new MBR(2), operation);
    }

    public void initWithPoint(SpatialSearchTree tree, int[] point) {
        this.initWithPoint(tree, point, 0);
    }

    public void initWithPoint(SpatialSearchTree tree, int[] point, int operation) {
        MBR r = new MBR(point.length);
        r.setLocation(point);
        this.initWithRect(tree, r, operation);
    }

    public void initWithRect(SpatialSearchTree tree, MBR window) {
        this.initWithRect(tree, window, 0);
    }

    public void initWithRect(SpatialSearchTree tree, MBR window, int operation) {
        if (!window.equals(this.rect) || operation != this.operation || tree.getRoot() != this.node[0]) {
            this.rect = window;
            this.operation = operation;
            this.node[0] = tree.getRoot();
            ++this.queryNum;
            this.reset();
        }
    }

    public void initWithObject(SpatialSearchTree tree, SpatialSearchTreeObject queryObj) {
        this.initWithObject(tree, queryObj, 0);
    }

    public void initWithObject(SpatialSearchTree tree, SpatialSearchTreeObject queryObj, int operation) {
        if (queryObj != null) {
            this.queryObj = queryObj;
            this.initWithRect(tree, queryObj.getMBR(), operation);
        }
    }

    public void reset() {
        this.resetLocks();
        this.index[0] = 0;
        this.pathLength = 1;
    }

    public void resetLocks() {
        int i = 1;
        while (i < 40 && this.node[i] != null) {
            if (!this.node[i].isRoot()) {
                this.node[i].resetLock();
            }
            ++i;
        }
    }
}

