/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import java.awt.Point;
import java.awt.Rectangle;

public class MBR {
    private int DIM;
    private int[] coord;
    private int[] ext;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int WIDTH = 0;
    public static final int HEIGHT = 1;
    public static final int DEPTH = 2;
    protected static final int[] P2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512};

    public MBR(int[] coords) {
        this(coords.length);
        int i = 0;
        while (i < coords.length) {
            this.coord[i] = coords[i];
            ++i;
        }
    }

    public MBR(int[] coords, int[] exts) {
        this(Math.min(coords.length, exts.length));
        int i = 0;
        while (i < this.coord.length) {
            this.coord[i] = coords[i];
            this.ext[i] = exts[i];
            ++i;
        }
    }

    public MBR(int d) {
        if (d <= 0) {
            throw new IllegalArgumentException("wrong dimension");
        }
        this.DIM = d;
        this.coord = new int[this.DIM];
        this.ext = new int[this.DIM];
    }

    public MBR(int x, int width) {
        this(1);
        this.coord[0] = x;
        this.ext[0] = width;
    }

    public MBR(int x, int y, int width, int height) {
        this(2);
        this.coord[0] = x;
        this.coord[1] = y;
        this.ext[0] = width;
        this.ext[1] = height;
    }

    public MBR(int x, int y, int z, int width, int height, int depth) {
        this(3);
        this.coord[0] = x;
        this.coord[1] = y;
        this.coord[2] = z;
        this.ext[0] = width;
        this.ext[1] = height;
        this.ext[2] = depth;
    }

    public MBR(Point p) {
        this(2);
        if (p == null) {
            throw new IllegalArgumentException("argument null");
        }
        this.coord[0] = p.x;
        this.coord[1] = p.y;
    }

    public MBR(Rectangle r) {
        this(2);
        if (r == null) {
            throw new IllegalArgumentException("argument null");
        }
        this.coord[0] = r.x;
        this.coord[1] = r.y;
        this.ext[0] = r.width;
        this.ext[1] = r.height;
    }

    public void add(int[] point) throws IllegalArgumentException {
        if (point == null) {
            return;
        }
        if (point.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            if (point[i] < this.coord[i]) {
                this.coord[i] = point[i];
            } else if (point[i] > this.coord[i] + this.ext[i]) {
                this.ext[i] = point[i] - this.coord[i];
            }
            ++i;
        }
    }

    public void add(MBR r) {
        if (r == null) {
            return;
        }
        if (r.numOfDimensions() < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            int v1 = Math.min(this.coord[i], r.coord[i]);
            int v2 = Math.max(this.coord[i] + this.ext[i], r.coord[i] + r.ext[i]);
            this.coord[i] = v1;
            this.ext[i] = v2 - v1;
            ++i;
        }
    }

    public int center(int d) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        return this.coord[d] + this.ext[d] / 2;
    }

    public Object clone() {
        MBR c = new MBR(this.DIM);
        int i = 0;
        while (i < this.DIM) {
            c.coord[i] = this.coord[i];
            c.ext[i] = this.ext[i];
            ++i;
        }
        return c;
    }

    public static MBR clone(MBR r) {
        if (r == null) {
            return null;
        }
        return (MBR)r.clone();
    }

    public double computeBorder() {
        double border = 0.0;
        int i = 0;
        while (i < this.DIM) {
            border += (double)(P2[this.DIM - 1] * this.extension(i));
            ++i;
        }
        return border;
    }

    public double computeVolume() {
        double volume = this.extension(0);
        int i = 1;
        while (i < this.DIM) {
            volume *= (double)this.extension(i);
            ++i;
        }
        return volume;
    }

    public boolean contains(int[] point) {
        return this.contains(point, 0);
    }

    public boolean contains(int[] point, int tolerance) {
        if (point == null || point.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            if (point[i] + tolerance < this.coord[i]) {
                return false;
            }
            if (point[i] - tolerance > this.coord[i] + this.ext[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(MBR r) {
        if (r == null || r.numOfDimensions() != this.DIM) {
            return false;
        }
        return this.contains(r.getMinCoords()) && this.contains(r.getMaxCoords());
    }

    public boolean contains(MBR r, int tolerance) {
        if (r == null || r.numOfDimensions() != this.DIM) {
            return false;
        }
        return this.contains(r.getMinCoords(), tolerance) && this.contains(r.getMaxCoords(), tolerance);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MBR) {
            MBR r = (MBR)obj;
            if (this.DIM != r.DIM) {
                return false;
            }
            int i = 0;
            while (i < this.DIM) {
                if (this.coord[i] != r.coord[i] || this.ext[i] != r.ext[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int extension(int d) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        return this.ext[d];
    }

    public Rectangle extractRectangle(int dimX, int dimY) throws IllegalArgumentException {
        if (dimX < 0 || dimX >= this.DIM || dimY < 0 || dimY >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        return new Rectangle(this.coord[dimX], this.coord[dimY], this.ext[dimX], this.ext[dimY]);
    }

    public int[] getCenterCoords() {
        int[] res = new int[this.DIM];
        int i = 0;
        while (i < this.DIM) {
            res[i] = this.coord[i] + this.ext[i] / 2;
            ++i;
        }
        return res;
    }

    public int[] getExtensions() {
        return this.ext;
    }

    public int[] getMaxCoords() {
        int[] res = new int[this.DIM];
        int i = 0;
        while (i < this.DIM) {
            res[i] = this.coord[i] + this.ext[i];
            ++i;
        }
        return res;
    }

    public int[] getMinCoords() {
        return this.coord;
    }

    public void grow(int[] values) throws IllegalArgumentException {
        if (values == null) {
            return;
        }
        if (values.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            int n = i;
            this.ext[n] = this.ext[n] + values[i];
            ++i;
        }
    }

    public MBR intersection(MBR r) {
        if (r == null || r.numOfDimensions() != this.DIM) {
            return null;
        }
        MBR res = new MBR(this.DIM);
        int i = 0;
        while (i < this.DIM) {
            int v1 = Math.max(this.coord[i], r.coord[i]);
            int v2 = Math.min(this.coord[i] + this.ext[i], r.coord[i] + r.ext[i]);
            if (v2 < v1) {
                return null;
            }
            res.coord[i] = v1;
            res.ext[i] = v2 - v1;
            ++i;
        }
        return res;
    }

    public double intersectionVolume(MBR r) {
        MBR iRect = this.intersection(r);
        return iRect == null ? 0.0 : iRect.computeVolume();
    }

    public boolean intersects(MBR r) {
        return this.intersects(r, 0);
    }

    public boolean intersects(MBR r, int tolerance) {
        if (r == null || r.numOfDimensions() != this.DIM) {
            return false;
        }
        int i = 0;
        while (i < this.DIM) {
            if (this.coord[i] + this.ext[i] + tolerance <= r.coord[i]) {
                return false;
            }
            if (this.coord[i] - tolerance >= r.coord[i] + r.ext[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int max(int d) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        return this.coord[d] + this.ext[d];
    }

    public int min(int d) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        return this.coord[d];
    }

    public int numOfDimensions() {
        return this.DIM;
    }

    public long quadDistanceFromCenter(int[] point) {
        if (point == null || point.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        long res = 0L;
        int i = 0;
        while (i < this.DIM) {
            long dv = this.center(i) - point[i];
            res += dv * dv;
            ++i;
        }
        return res;
    }

    public void setBounds(int[] coords, int[] extensions) throws IllegalArgumentException {
        int i;
        if (coords != null) {
            if (coords.length < this.DIM) {
                throw new IllegalArgumentException("wrong argument");
            }
            i = 0;
            while (i < this.DIM) {
                this.coord[i] = coords[i];
                ++i;
            }
        }
        if (extensions != null) {
            if (extensions.length < this.DIM) {
                throw new IllegalArgumentException("wrong argument");
            }
            i = 0;
            while (i < this.DIM) {
                this.ext[i] = extensions[i];
                ++i;
            }
        }
    }

    public MBR setBoundsByPoints(int[] p1, int[] p2) throws IllegalArgumentException {
        if (p1 == null || p1.length < this.DIM || p2 == null || p2.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            this.coord[i] = Math.min(p1[i], p2[i]);
            this.ext[i] = Math.max(p1[i], p2[i]) - this.coord[i];
            ++i;
        }
        return this;
    }

    public void setBounds(int x, int width) throws IllegalArgumentException {
        if (this.DIM != 1) {
            throw new IllegalArgumentException("wrong argument");
        }
        this.coord[0] = x;
        this.ext[0] = width;
    }

    public void setBounds(int x, int y, int width, int height) throws IllegalArgumentException {
        if (this.DIM != 2) {
            throw new IllegalArgumentException("wrong argument");
        }
        this.coord[0] = x;
        this.coord[1] = y;
        this.ext[0] = width;
        this.ext[1] = height;
    }

    public void setBounds(int x, int y, int z, int width, int height, int depth) throws IllegalArgumentException {
        if (this.DIM != 3) {
            throw new IllegalArgumentException("wrong argument");
        }
        this.coord[0] = x;
        this.coord[1] = y;
        this.coord[2] = z;
        this.ext[0] = width;
        this.ext[1] = height;
        this.ext[2] = depth;
    }

    public void setBounds(MBR r) throws IllegalArgumentException {
        if (r == null || r.numOfDimensions() != this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        this.setBounds(r.getMinCoords(), r.getExtensions());
    }

    public void setExtension(int d, int value) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        this.ext[d] = value;
    }

    public void setLocation(int[] coords) throws IllegalArgumentException {
        this.setBounds(coords, null);
    }

    public void setMin(int d, int value) throws IllegalArgumentException {
        if (d < 0 || d >= this.DIM) {
            throw new IllegalArgumentException("wrong dimension");
        }
        this.coord[d] = value;
    }

    public void setSize(int[] extensions) throws IllegalArgumentException {
        this.setBounds(null, extensions);
    }

    public String toString() {
        String res = "spatial.MBR[DIM=" + this.DIM + " coord[]=";
        int i = 0;
        while (i < this.DIM) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + this.coord[i];
            ++i;
        }
        res = String.valueOf(res) + " ext[]=";
        i = 0;
        while (i < this.DIM) {
            res = String.valueOf(res) + (i == 0 ? "" : ",") + this.ext[i];
            ++i;
        }
        return res;
    }

    public void translate(int[] values) throws IllegalArgumentException {
        if (values == null) {
            return;
        }
        if (values.length < this.DIM) {
            throw new IllegalArgumentException("wrong argument");
        }
        int i = 0;
        while (i < this.DIM) {
            int n = i;
            this.coord[n] = this.coord[n] + values[i];
            ++i;
        }
    }

    public MBR union(MBR r) {
        if (r == null || r.numOfDimensions() != this.DIM) {
            return (MBR)this.clone();
        }
        MBR res = new MBR(this.DIM);
        int i = 0;
        while (i < this.DIM) {
            int v1 = Math.min(this.coord[i], r.coord[i]);
            int v2 = Math.max(this.coord[i] + this.ext[i], r.coord[i] + r.ext[i]);
            res.coord[i] = v1;
            res.ext[i] = v2 - v1;
            ++i;
        }
        return res;
    }
}

