/*
 * Decompiled with CFR 0.152.
 */
package spatial;

import spatial.MBR;
import spatial.SpatialQuery;
import spatial.SpatialSearchTreeEntry;
import spatial.SpatialSearchTreeObject;

public abstract class BasicSpatialQuery
implements SpatialQuery {
    protected int tolerance = 0;

    public boolean areEqual(SpatialSearchTreeObject queryObj, SpatialSearchTreeObject storedObj) {
        if (queryObj == null) {
            return false;
        }
        return queryObj.equals(storedObj);
    }

    public boolean conditionFulfilled(MBR rect, MBR entryMBR) {
        if (rect == null) {
            return false;
        }
        return rect.intersects(entryMBR, this.tolerance);
    }

    public boolean conditionFulfilled(MBR rect, SpatialSearchTreeEntry entry) {
        if (rect == null || entry == null) {
            return false;
        }
        return rect.intersects(entry.getMBR(), this.tolerance);
    }

    public boolean conditionFulfilled(MBR rect, SpatialSearchTreeObject obj) {
        if (rect == null || obj == null) {
            return false;
        }
        return rect.intersects(obj.getMBR(), this.tolerance);
    }

    public void setTolerance(int tolerance) {
        this.tolerance = tolerance;
    }
}

