/*
 * Decompiled with CFR 0.152.
 */
package showmap;

import drawables.DrawableObject;
import drawables.DrawablePresentation;
import java.awt.Color;
import java.net.URL;
import routing.Network;
import routing.Node;
import routing.PathEdge;
import showmap.LoadDrawables;
import showmap.ShowMap;

public class ShowNetworkMap
extends ShowMap {
    protected Network net = null;
    protected Node start = null;
    protected Node stop = null;
    protected PathEdge path = null;
    protected boolean nodesSelectable = true;
    protected boolean edgesSelectable = false;
    private URL nodeURL = null;

    public void computeFastWay() {
        if (this.path != null) {
            this.path.setStandardAppearance();
        }
        this.path = this.net.computeFastWay2(this.start, this.stop);
        if (this.path != null) {
            this.path.changePresentation("Way");
        }
        this.repaint();
    }

    public void computeShortestWay() {
        if (this.path != null) {
            this.path.setStandardAppearance();
        }
        this.path = this.net.computeFastestWay(this.start, this.stop);
        if (this.path != null) {
            this.path.changePresentation("Way");
        }
        this.repaint();
    }

    public void computeShortestWays(int threshold) {
        if (this.path != null) {
            this.path.setStandardAppearance();
        }
        this.path = this.net.computeFastWays(this.start, this.stop, threshold);
        if (this.path != null) {
            this.path.changePresentation("Way");
        }
        this.repaint();
    }

    protected void depictObjectAttributes(DrawableObject obj) {
        super.depictObjectAttributes(obj);
        if (obj == null) {
            return;
        }
        this.getNameLabel().setText(obj.getName());
        this.getTagLabel().setText(" ");
        this.getValueLabel().setText(" ");
    }

    protected String getInfoText(DrawableObject symb) {
        if (symb == null) {
            return null;
        }
        if (symb.getDrawable(0).getClass().getName().startsWith("routing.Node")) {
            return symb.getName();
        }
        return null;
    }

    public Network getNetwork() {
        return this.net;
    }

    public void init() {
        this.net = new Network();
        super.init();
    }

    protected void initDrawablePresentation() {
        DrawablePresentation.init();
        int i = 0;
        while (i <= 7) {
            DrawablePresentation.newDrawablePresentation("T" + i, false, new Color(180 + i * 10, 255, 100), Color.red);
            ++i;
        }
        i = 8;
        while (i <= 20) {
            DrawablePresentation.newDrawablePresentation("T" + i, false, new Color(255, 255 - (i - 8) * 10, 100), Color.red);
            ++i;
        }
        DrawablePresentation.newDrawablePresentation("T21", false, new Color(255, 200, 150), Color.red);
        DrawablePresentation.newDrawablePresentation("T22", false, new Color(0, 200, 0), Color.red);
        DrawablePresentation.newDrawablePresentation("T23", false, new Color(120, 255, 255), Color.red);
        DrawablePresentation.newDrawablePresentation("T25", false, new Color(120, 255, 255), Color.red);
        DrawablePresentation.newDrawablePresentation("T26", false, new Color(120, 255, 255), Color.red);
        DrawablePresentation.newDrawablePresentation("T27", false, new Color(120, 255, 255), Color.red);
        DrawablePresentation.newDrawablePresentation("T28", false, Color.red, Color.red);
        DrawablePresentation.newDrawablePresentation("T29", false, new Color(255, 150, 150), Color.red, 0, 2, 0, 128, 33);
        DrawablePresentation.newDrawablePresentation("T29", false, new Color(255, 150, 150), Color.red, 0, 3, 0, 32, 1);
        DrawablePresentation.newDrawablePresentation("T30", false, new Color(255, 175, 220), Color.red);
        DrawablePresentation.newDrawablePresentation("T31", false, new Color(255, 190, 190), Color.red);
        int[] size = new int[]{10, 9, 9, 8, 8, 8, 8, 7, 6, 6};
        int i2 = 1;
        while (i2 <= 9) {
            DrawablePresentation.newDrawablePresentation("TN" + i2, false, Color.black, Color.red, 0, size[i2] + 1, size[i2] / 2 + 3, 65536, 0);
            DrawablePresentation.newDrawablePresentation("TB" + i2, false, Color.black, Color.red, 1, size[i2] + 1, size[i2] / 2 + 3, 65536, 0);
            DrawablePresentation.newDrawablePresentation("TI" + i2, false, Color.black, Color.red, 2, size[i2] + 1, size[i2] / 2 + 3, 65536, 0);
            ++i2;
        }
        DrawablePresentation.newDrawablePresentation("C1", false, Color.black, Color.lightGray, Color.black, Color.yellow, 2, 9);
        DrawablePresentation.newDrawablePresentation("C2", false, Color.black, Color.lightGray, Color.black, Color.yellow, 2, 8);
        DrawablePresentation.newDrawablePresentation("C3", false, Color.black, Color.lightGray, Color.black, Color.yellow, 0, 8);
        DrawablePresentation.newDrawablePresentation("C4", false, Color.black, Color.lightGray, Color.black, Color.yellow, 3, 7);
        DrawablePresentation.newDrawablePresentation("C5", false, Color.black, Color.lightGray, Color.black, Color.yellow, 1, 7);
        DrawablePresentation.newDrawablePresentation("C6", false, Color.black, Color.lightGray, Color.black, Color.yellow, 4, 7);
        DrawablePresentation.newDrawablePresentation("C7", false, Color.black, Color.lightGray, Color.black, Color.yellow, 1, 6);
        DrawablePresentation.newDrawablePresentation("C8", false, Color.black, Color.lightGray, Color.black, Color.yellow, 1, 5);
        DrawablePresentation.newDrawablePresentation("C9", false, Color.black, Color.lightGray, Color.black, Color.yellow, 1, 5);
        i2 = 0;
        while (i2 <= 5) {
            DrawablePresentation.newDrawablePresentation("St" + i2, false, new Color(191, 0, 0), Color.red, 1, 10 + i2);
            if (i2 < 2) {
                DrawablePresentation.newDrawablePresentation("Ld" + i2, false, Color.red, Color.red, 0, 6 + 2 * i2);
            } else {
                DrawablePresentation.newDrawablePresentation("Ld" + i2, false, new Color(223, 0, 0), Color.red, 0, 6 + 2 * i2);
            }
            DrawablePresentation.newDrawablePresentation("Me" + i2, false, Color.blue, Color.red, 0, 8 + 2 * i2);
            DrawablePresentation.newDrawablePresentation("Se" + i2, false, Color.blue, Color.red, 0, 6 + i2);
            DrawablePresentation.newDrawablePresentation("Fl" + i2, false, Color.blue, Color.red, 0, 5 + i2);
            DrawablePresentation.newDrawablePresentation("In" + i2, false, new Color(0, 159, 0), Color.red, 0, 5 + i2);
            ++i2;
        }
        DrawablePresentation.newDrawablePresentation("Mount", false, Color.black, Color.black, Color.black, Color.red, 5, 7);
        DrawablePresentation.newDrawablePresentation("TMount", false, Color.black, Color.red, 0, 7, 6, 65536, 0);
    }

    public boolean isEdge(String id) {
        return this.net.getEdges().get(new Long(id)) != null;
    }

    public boolean isNode(String id) {
        return this.net.getNodes().get(new Long(id)) != null;
    }

    protected int readDrawables(int objNum, URL url, int index) {
        if (index == 0 || index > 2) {
            return super.readDrawables(objNum, url, index);
        }
        if (index == 1) {
            this.nodeURL = url;
            return objNum;
        }
        this.showStatus("read and create network ...");
        this.net.createByNetworkFiles(this.nodeURL, url, this.drawableObjects);
        return objNum;
    }

    public void resetWay() {
        if (this.path != null) {
            this.path.setStandardAppearance();
        }
        this.repaint();
    }

    public void setEdgeSelectability(boolean on) {
        this.edgesSelectable = on;
        int i = 0;
        while (i < this.net.getEdges().getNumOfClasses()) {
            this.setSelectionMode("Edge" + i, on);
            ++i;
        }
    }

    public void setNodeSelectability(boolean on) {
        this.nodesSelectable = on;
        int i = 0;
        while (i < this.net.getNodes().getNumOfClasses()) {
            this.setSelectionMode("Node" + i, on);
            ++i;
        }
    }

    protected void setSelectionMode(String presName, boolean on) {
        DrawablePresentation p = DrawablePresentation.get(presName);
        while (p != null) {
            p.setSelectability(on);
            p = p.getNext();
        }
    }

    public void setStartNode(long id) {
        this.start = this.net.getNodes().get(id);
    }

    public void setStartNodeAsString(String id) {
        try {
            long pId = new Long(id);
            this.setStartNode(pId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setStopNode(long id) {
        this.stop = this.net.getNodes().get(id);
    }

    public void setStopNodeAsString(String id) {
        try {
            long pId = new Long(id);
            this.setStopNode(pId);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected void startLoadingThread() {
        URL[] url = new URL[3];
        URL actURL = this.computeURL(this.getParameter("urlgb"));
        if (actURL != null) {
            url[0] = actURL;
        }
        if (this.getParameter("urlne") != null) {
            url[1] = this.computeURL(String.valueOf(this.getParameter("urlne")) + ".node");
            url[2] = this.computeURL(String.valueOf(this.getParameter("urlne")) + ".edge");
        } else if (this.getParameter("urlnez") != null) {
            url[1] = this.computeURL(String.valueOf(this.getParameter("urlnez")) + ".node.zip");
            url[2] = this.computeURL(String.valueOf(this.getParameter("urlnez")) + ".edge.zip");
        }
        new LoadDrawables((ShowMap)this, url, 0).start();
    }
}

