/*
 * Decompiled with CFR 0.152.
 */
package routing;

import routing.Edge;
import routing.Edges;
import routing.WeightManager;

public class StandardWeightManager
implements WeightManager {
    protected Edges edges = null;

    public StandardWeightManager(Edges edges) {
        this.edges = edges;
    }

    public double computeWeight(double distance) {
        return this.computeWeight(distance, this.edges.getSpeed(0));
    }

    public double computeWeight(double distance, double speed) {
        if (speed != 0.0) {
            return distance / speed;
        }
        return Double.MAX_VALUE;
    }

    public double getWeight(Edge edge) {
        if (this.edges != null) {
            return edge.getLength() / (double)this.edges.getSpeed(edge.getEdgeClass());
        }
        return edge.getLength();
    }

    public double getWeight(Edge edge, boolean forwards) {
        if (this.edges != null) {
            return edge.getLength() / (double)this.edges.getSpeed(edge.getEdgeClass());
        }
        return edge.getLength();
    }
}

