/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.DrawablePresentation;
import routing.Edge;
import routing.Node;

public class PathEdge {
    protected Edge edge = null;
    protected boolean forwards = true;
    protected double origWeight = 0.0;
    protected PathEdge next = null;

    public PathEdge(Edge edge, boolean forwards) {
        this.edge = edge;
        this.forwards = forwards;
    }

    public PathEdge(Edge edge, boolean forwards, double origWeight) {
        this.edge = edge;
        this.forwards = forwards;
        this.origWeight = origWeight;
    }

    public PathEdge(Edge edge, boolean forwards, double origWeight, PathEdge next) {
        this.edge = edge;
        this.forwards = forwards;
        this.origWeight = origWeight;
        this.next = next;
    }

    public PathEdge addPath(PathEdge path) {
        if (this.next == null) {
            this.next = path;
            return path;
        }
        return this.next.addPath(path);
    }

    public void changePresentation(String presName) {
        this.edge.setPresentation(DrawablePresentation.get(presName));
        if (this.next != null) {
            this.next.changePresentation(presName);
        }
    }

    public boolean checkForDestinationNode(Node node) {
        PathEdge currEdge = this;
        while (currEdge.next != null) {
            currEdge = currEdge.next;
        }
        return currEdge.getDestinationNode() == node;
    }

    public int computeDegree() {
        if (this.next == null) {
            return 0;
        }
        return this.next.computeDegree() + this.getStartingNode().getNumOfEdges();
    }

    public double computeDistance() {
        if (this.next == null) {
            return this.edge.getWeight();
        }
        return this.edge.getWeight() + this.next.computeDistance();
    }

    public int computeNumber() {
        if (this.next == null) {
            return 1;
        }
        return this.next.computeNumber() + 1;
    }

    public void debugPrint() {
        Node node = this.getStartingNode();
        System.out.print("1: ");
        node.debugPrint(1);
        System.out.println(" - " + node.getDistanceOfWay(2));
        node = this.edge.getOppositeNode(node);
        System.out.print("2: ");
        node.debugPrint(1);
        System.out.println(" - " + node.getDistanceOfWay(2));
        if (this.next != null) {
            this.next.debugPrint();
        } else {
            System.out.println("***");
        }
    }

    public PathEdge findEdge(Edge pEdge) {
        if (pEdge == null) {
            return null;
        }
        if (pEdge.equals(this.edge)) {
            return this;
        }
        if (this.next == null) {
            return null;
        }
        return this.next.findEdge(pEdge);
    }

    public Node getDestinationNode() {
        if (this.forwards) {
            return this.edge.getNode2();
        }
        return this.edge.getNode1();
    }

    public Edge getEdge() {
        return this.edge;
    }

    public boolean getForwards() {
        return this.forwards;
    }

    public Edge getLastEdge() {
        if (this.next == null) {
            return this.edge;
        }
        return this.next.getLastEdge();
    }

    public PathEdge getNext() {
        return this.next;
    }

    public double getOrigWeight() {
        return this.origWeight;
    }

    public Node getStartingNode() {
        if (this.forwards) {
            return this.edge.getNode1();
        }
        return this.edge.getNode2();
    }

    public void select() {
        this.edge.setSelection(true);
        if (this.next != null) {
            this.next.select();
        }
    }

    public void setNext(PathEdge path) {
        this.next = path;
    }

    public void setStandardAppearance() {
        this.edge.setStandardAppearance();
        if (this.next != null) {
            this.next.setStandardAppearance();
        }
    }
}

