/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.Drawable;
import drawables.DrawablePresentation;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataOutput;
import java.io.IOException;
import routing.Edge;
import routing.Nodes;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class Node
extends Drawable {
    protected int x = 0;
    protected int y = 0;
    private long id = 0L;
    private short nodeClass = 0;
    private byte numOfEdges = 0;
    private byte actEdge = 0;
    private String name = null;
    private Edge[] edge = new Edge[3];
    private Nodes nodes = null;
    private int mark = 0;
    private double[] distanceOfWay = new double[]{0.0, 0.0};
    private byte[] wayEdge = new byte[]{-1, -1};
    protected short[] heapPos = new short[2];

    public Node(long id, int x, int y) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.layer = (byte)2;
        this.pres = DrawablePresentation.get("Node0");
    }

    public Node(long id, int x, int y, String name, Nodes nodes) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.layer = (byte)2;
        this.pres = DrawablePresentation.get("Node" + (nodes.getNumOfClasses() - 1));
        this.minScale = nodes.minScale[nodes.getNumOfClasses() - 1];
        this.maxScale = 0;
        this.name = name;
        this.nodes = nodes;
        this.nodeClass = (short)(nodes.getNumOfClasses() - 1);
    }

    public Node(long id, int x, int y, Nodes nodes) {
        this(id, x, y, null, nodes);
    }

    protected void adaptClass(int newEdgeClass) {
        if (newEdgeClass + 1 < this.nodeClass) {
            this.nodeClass = (short)(newEdgeClass + 1);
            this.setMinScale(this.nodes.minScale[this.nodeClass]);
            this.setPresentation(DrawablePresentation.get("Node" + this.nodeClass));
        } else if (newEdgeClass + 1 == this.nodeClass && this.numOfEdges > 2) {
            int n = 0;
            int i = 0;
            while (i < this.numOfEdges) {
                if (this.edge[i].getEdgeClass() + 1 == this.nodeClass) {
                    ++n;
                }
                ++i;
            }
            if (n > 2) {
                this.nodeClass = (short)(this.nodeClass - 1);
                this.setMinScale(this.nodes.minScale[this.nodeClass]);
                this.setPresentation(DrawablePresentation.get("Node" + this.nodeClass));
            }
        }
    }

    public void addEdge(Edge newEdge) {
        if (this.numOfEdges >= this.edge.length) {
            Edge[] newEdges = new Edge[2 * this.edge.length];
            int i = 0;
            while (i < this.edge.length) {
                newEdges[i] = this.edge[i];
                ++i;
            }
            this.edge = newEdges;
        }
        try {
            byte by = this.numOfEdges;
            this.numOfEdges = (byte)(by + 1);
            this.edge[by] = newEdge;
            this.adaptClass(newEdge.getEdgeClass());
        }
        catch (Exception ex) {
            System.out.println("ex " + ex);
        }
    }

    public void clearMark(int value) {
        if (this.isMarked(value)) {
            this.mark -= value;
        }
    }

    public void clearWays() {
        this.wayEdge[0] = -1;
        this.wayEdge[1] = -1;
    }

    public double computeDistanceTo(int x, int y) {
        return Drawable.computeDistance(this.x, this.y, x, y);
    }

    public void debugPrint(int way) {
        System.out.print(String.valueOf(this.name) + " - " + this.getDistanceOfWay(way));
    }

    public double distanceTo(Node node) {
        return this.computeDistanceTo(node.getX(), node.getY());
    }

    protected void drawProtected(Graphics g, int scale, int mode, int pvalue) {
        DrawablePresentation ap = this.pres.get(scale, mode, pvalue);
        int size = ap.getSize();
        try {
            size *= this.obj.getDataValue(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.selected) {
            g.setColor(ap.getSelectionFillColor());
        } else {
            g.setColor(ap.getFillColor());
        }
        Object pol = null;
        g.fillOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
        if (this.selected) {
            g.setColor(ap.getSelectionColor());
        } else {
            g.setColor(ap.getColor());
        }
        g.drawOval(this.x / scale - size / 2, this.y / scale - size / 2, size, size);
    }

    public boolean equals(Object node) {
        if (node == null) {
            return false;
        }
        return this.id == ((Node)node).id;
    }

    public double getDistanceOfWay(int way) {
        return this.distanceOfWay[way - 1];
    }

    public Edge getFirstEdge() {
        if (this.numOfEdges == 0) {
            return null;
        }
        byte by = this.actEdge = 0;
        this.actEdge = (byte)(by + 1);
        return this.edge[by];
    }

    public long getID() {
        return this.id;
    }

    public Rectangle getMBR() {
        return new Rectangle(this.x, this.y, 0, 0);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public Edge getNextEdge() {
        if (this.actEdge >= this.numOfEdges) {
            return null;
        }
        byte by = this.actEdge;
        this.actEdge = (byte)(by + 1);
        return this.edge[by];
    }

    public int getNodeClass() {
        return this.nodeClass;
    }

    public Nodes getNodeContainer() {
        return this.nodes;
    }

    public int getNumOfEdges() {
        return this.numOfEdges;
    }

    public Edge getWayEdge(int way) {
        if (this.wayEdge[way - 1] < 0) {
            return null;
        }
        return this.edge[this.wayEdge[way - 1]];
    }

    public int hashCode() {
        return (int)this.id;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void highlight(String presName) {
        this.setPresentation(DrawablePresentation.get(presName));
    }

    public boolean interacts(int px, int py, int scale) {
        int pvalue;
        int actMode = this.container == null ? 0 : this.container.getMode();
        DrawablePresentation ap = this.pres.get(scale, actMode, pvalue = this.obj == null ? Integer.MIN_VALUE : this.obj.getPresValue());
        int size = Math.abs(ap.getSize() * pvalue) / 10;
        if (size < 4) {
            size = 4;
        }
        return px >= this.x - size / 2 * scale && px <= this.x + size / 2 * scale && py >= this.y - size / 2 * scale - 1 && py <= this.y + size / 2 * scale;
    }

    public boolean isMarked(int value) {
        if (this.mark > this.nodes.nullMark) {
            return (this.mark - this.nodes.nullMark & value) > 0;
        }
        return false;
    }

    public void mark(int value) {
        this.mark = this.mark > this.nodes.nullMark ? this.nodes.nullMark + (this.mark - this.nodes.nullMark | value) : this.nodes.nullMark + value;
        if (this.nodes.maxMark < this.mark) {
            this.nodes.maxMark = this.mark;
        }
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
        int i = 0;
        while (i < this.numOfEdges) {
            this.edge[i].announceMove(this);
            ++i;
        }
    }

    public EntryReadable read(EntryInput r) {
        throw new UnsupportedOperationException("Node.read is not implemented!");
    }

    public void removeEdge(Edge oldEdge) {
        int edgeIndex = 0;
        while (edgeIndex < this.numOfEdges && this.edge[edgeIndex] != oldEdge) {
            ++edgeIndex;
        }
        if (edgeIndex == this.numOfEdges) {
            return;
        }
        this.edge[edgeIndex] = this.edge[this.numOfEdges - 1];
        this.numOfEdges = (byte)(this.numOfEdges - 1);
    }

    public void replaceBy(Node node) {
        int i = this.numOfEdges - 1;
        while (i >= 0) {
            this.edge[i].replaceNode(this, node);
            --i;
        }
        if (this.numOfEdges != 0) {
            System.err.println("Node.replaceBy: numOfEdges != 0");
        }
    }

    public void setDistanceOfWay(int way, double distance) {
        this.distanceOfWay[way - 1] = distance;
    }

    protected void setID(long newID) {
        this.id = newID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStandardAppearance() {
        this.setPresentation(DrawablePresentation.get("Node" + this.nodeClass));
    }

    public void setWay(int way, Edge e) {
        if (!this.isMarked(1)) {
            this.wayEdge[0] = -1;
        }
        if (!this.isMarked(2)) {
            this.wayEdge[1] = -1;
        }
        int i = 0;
        while (i < this.numOfEdges) {
            if (this.edge[i] == e) {
                this.wayEdge[way - 1] = (byte)i;
            }
            ++i;
        }
    }

    public boolean write(DataOutput out) {
        try {
            byte l = (byte)this.getName().length();
            out.writeByte(l);
            if (l > 0) {
                out.write(this.getName().getBytes());
            }
            out.writeLong(this.id);
            out.writeInt(this.getX());
            out.writeInt(this.getY());
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void write(EntryWriter out) {
        out.print(this.id);
        out.print('\t');
        out.print(this.getX());
        out.print('\t');
        out.print(this.getY());
        out.println(String.valueOf('\t') + this.getName());
    }

    protected void writeProtected(EntryWriter out, int type) {
        throw new UnsupportedOperationException("Node.writeProtected is not implemented!");
    }
}

