/*
 * Decompiled with CFR 0.152.
 */
package routing;

import drawables.Drawable;
import drawables.DrawableLine;
import drawables.DrawablePresentation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataOutput;
import java.io.IOException;
import routing.Edges;
import routing.Node;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;
import util.Num;

public class Edge
extends Drawable {
    private long id = 0L;
    private double length = 0.0;
    protected Node node1 = null;
    protected Node node2 = null;
    private String name = null;
    private short edgeClass = 0;
    private short usage = 0;
    private int mark = 0;
    private Edges edges = null;

    protected Edge(long id) {
        this.id = id;
        this.pres = DrawablePresentation.get("default");
    }

    public Edge(long id, int edgeClass, Node node1, Node node2, String name) {
        this.id = id;
        this.pres = DrawablePresentation.get("default");
        this.edgeClass = (short)edgeClass;
        this.node1 = node1;
        this.node2 = node2;
        this.name = name;
        this.length = node1.distanceTo(node2);
    }

    public Edge(long id, int edgeClass, Node node1, Node node2, String name, Edges edges) {
        this.id = id;
        this.pres = DrawablePresentation.get("Edge" + Num.putIntoInterval(edgeClass, 0, edges.getNumOfClasses()));
        this.edgeClass = (short)Num.putIntoInterval(edgeClass, 0, edges.getNumOfClasses());
        this.node1 = node1;
        this.node2 = node2;
        this.name = name;
        this.edges = edges;
        this.minScale = edges.minScale[Num.putIntoInterval(edgeClass, 0, edges.getNumOfClasses())];
        this.maxScale = 0;
        this.length = node1.distanceTo(node2);
    }

    public void announceMove(Node node) {
        this.length = this.node1.distanceTo(this.node2);
    }

    public void clearMark() {
        this.mark = this.edges.nullMark;
    }

    public int compareTo(Object edge) {
        if (edge == null) {
            return 1;
        }
        return this.getName().compareTo(((Edge)edge).getName());
    }

    public void debugPrint() {
        System.out.print(String.valueOf(this.node1.getId()) + " - " + this.node2.getId());
    }

    public void decUsage() {
        if (this.usage < 1) {
            System.out.println("Edge " + this.id + ": " + this.usage + "--");
        }
        this.usage = (short)(this.usage - 1);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        Color color = ap.getColor();
        if (this.selected) {
            color = ap.getSelectionColor();
        }
        int cx1 = this.node1.getX() / scale;
        int cy1 = this.node1.getY() / scale;
        int cx2 = this.node2.getX() / scale;
        int cy2 = this.node2.getY() / scale;
        DrawableLine.drawProtected(g, ap, color, color, cx1, cy1, cx2, cy2);
    }

    public boolean equals(Object edge) {
        if (edge == null) {
            return false;
        }
        return this.id == ((Edge)edge).id;
    }

    public int getEdgeClass() {
        return this.edgeClass;
    }

    public Edges getEdgeContainer() {
        return this.edges;
    }

    public long getID() {
        return this.id;
    }

    public double getLength() {
        return this.length;
    }

    public Rectangle getMBR() {
        int maxY;
        int minX = Math.min(this.node1.getX(), this.node2.getX());
        int minY = Math.min(this.node1.getY(), this.node2.getY());
        int maxX = Math.max(this.node1.getX(), this.node2.getX());
        if (maxX == minX) {
            ++maxX;
        }
        if ((maxY = Math.max(this.node1.getY(), this.node2.getY())) == minY) {
            ++maxY;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "";
    }

    public Node getNode1() {
        return this.node1;
    }

    public Node getNode2() {
        return this.node2;
    }

    public Node getOneNode() {
        return this.node1;
    }

    public Node getOppositeNode(Node oneNode) {
        if (this.node1.equals(oneNode)) {
            return this.node2;
        }
        return this.node1;
    }

    public int getUsage() {
        return this.usage;
    }

    public double getWeight() {
        return this.edges.getWeightManager().getWeight(this);
    }

    public double getWeight(Node from) {
        return this.edges.getWeightManager().getWeight(this, this.node1.equals(from));
    }

    public double getWeight(boolean forwards) {
        return this.edges.getWeightManager().getWeight(this, forwards);
    }

    public boolean hasAsNode(Node node) {
        return this.node1.equals(node) || this.node2.equals(node);
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void incUsage() {
        this.usage = (short)(this.usage + 1);
    }

    public boolean interacts(int x, int y, int scale) {
        int minX = Math.min(this.node1.getX(), this.node2.getX());
        int minY = Math.min(this.node1.getY(), this.node2.getY());
        int maxX = Math.max(this.node1.getX(), this.node2.getX());
        int maxY = Math.max(this.node1.getY(), this.node2.getY());
        return DrawableLine.interacts(x, y, this.node1.getX(), this.node1.getY(), this.node2.getX(), this.node2.getY(), minX, minY, maxX, maxY, scale);
    }

    public boolean isDirectedTo(Node pNode2) {
        return this.node2.equals(pNode2);
    }

    public boolean isMarked() {
        return this.mark > this.edges.nullMark;
    }

    public boolean isStartingFrom(Node pNode1) {
        return this.node1.equals(pNode1);
    }

    public void mark() {
        this.mark = this.edges.nullMark + 1;
    }

    public EntryReadable read(EntryInput r) {
        throw new UnsupportedOperationException("Node.read is not implemented!");
    }

    public void replaceNode(Node oldNode, Node newNode) {
        if (this.node1 == oldNode) {
            this.node1.removeEdge(this);
            this.node1 = newNode;
            this.node1.addEdge(this);
        } else if (this.node2 == oldNode) {
            this.node2.removeEdge(this);
            this.node2 = newNode;
            this.node2.addEdge(this);
        }
        this.length = this.node1.distanceTo(this.node2);
    }

    public void setEdgeClass(short edgeClass) {
        if (edgeClass < this.edgeClass) {
            this.getNode1().adaptClass(edgeClass);
            this.getNode2().adaptClass(edgeClass);
        }
        this.edgeClass = edgeClass;
        this.setPresentation(DrawablePresentation.get("Edge" + edgeClass));
    }

    protected void setID(long newID) {
        this.id = newID;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStandardAppearance() {
        this.setPresentation(DrawablePresentation.get("Edge" + this.edgeClass));
    }

    public void setUsage(short usage) {
        this.usage = usage;
    }

    public boolean write(DataOutput out) {
        try {
            out.writeLong(this.node1.getID());
            out.writeLong(this.node2.getID());
            byte l = (byte)this.getName().length();
            out.writeByte(l);
            if (l > 0) {
                out.write(this.getName().getBytes());
            }
            out.writeLong(this.id);
            out.writeInt(this.edgeClass);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void write(EntryWriter out) {
        out.print(this.id);
        out.print('\t');
        out.print(this.node1.getID());
        out.print('\t');
        out.print(this.node2.getID());
        out.print('\t');
        out.print(this.edgeClass);
        out.println(String.valueOf('\t') + this.name);
    }

    protected void writeProtected(EntryWriter out, int type) {
        throw new UnsupportedOperationException("Edge.writeProtected is not implemented!");
    }
}

