/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.EdgeClasses;
import generator2.ExternalObjects;
import generator2.ObjectClasses;
import routing.Edge;
import routing.WeightManager;

public class WeightManagerForDataGenerator
implements WeightManager {
    private EdgeClasses edgeClasses = null;
    private ObjectClasses objClasses = null;
    private ExternalObjects extObjects = null;
    private int actObjClass = 0;

    public WeightManagerForDataGenerator(EdgeClasses edgeClasses, ObjectClasses objClasses, ExternalObjects extObjects) {
        this.edgeClasses = edgeClasses;
        this.objClasses = objClasses;
        this.extObjects = extObjects;
    }

    public double computeWeight(double distance) {
        return this.computeWeight(distance, this.objClasses.getMaxSpeed(0));
    }

    public double computeWeight(double distance, double speed) {
        if (speed != 0.0) {
            return distance / speed;
        }
        return Double.MAX_VALUE;
    }

    public EdgeClasses getEdgeClasses() {
        return this.edgeClasses;
    }

    public ObjectClasses getObjectClasses() {
        return this.objClasses;
    }

    public double getWeight(Edge edge) {
        return this.getWeight(edge, edge.getLength());
    }

    private double getWeight(Edge edge, double edgeLength) {
        double newEdgeWeight;
        int decFactor;
        double objWeight = this.computeWeight(edgeLength, this.objClasses.getMaxSpeed(this.actObjClass));
        double edgeWeight = this.computeWeight(edgeLength, this.edgeClasses.deceleratedSpeed(edge.getEdgeClass(), edge.getUsage()));
        if (this.extObjects != null && (decFactor = this.extObjects.computeDecrease(edge)) < 100 && (newEdgeWeight = this.computeWeight(edgeLength, this.edgeClasses.getMaxSpeed(edge.getEdgeClass()) * decFactor / 100)) > edgeWeight) {
            edgeWeight = newEdgeWeight;
        }
        if (edgeWeight > objWeight) {
            return edgeWeight;
        }
        return objWeight;
    }

    public double getWeight(Edge edge, boolean forwards) {
        return this.getWeight(edge, edge.getLength());
    }

    public void setActualObjectClass(int actObjClass) {
        this.actObjClass = actObjClass;
    }
}

