/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataGenerator;
import generator2.DataSpace;
import generator2.RandomGenerator;
import generator2.Time;
import java.util.Properties;
import java.util.Random;

public class ReRoute {
    protected Time time;
    protected DataSpace ds;
    protected Properties properties;
    protected int numOfRoutesByComparison = 0;
    protected int numOfRoutesByEvent = 0;
    protected int speedProbability;
    protected int eventProbability;
    protected int timeLimit;
    protected int speedThreshold;
    protected Random random;

    public ReRoute(Properties properties, Time time, DataSpace ds) {
        this.properties = properties;
        this.time = time;
        this.ds = ds;
        this.random = RandomGenerator.get(properties);
        this.speedThreshold = DataGenerator.getProperty(properties, "speedThreshold", 2);
        this.speedProbability = DataGenerator.getProperty(properties, "speedProbability", 20);
        this.eventProbability = DataGenerator.getProperty(properties, "eventProbability", 200);
        this.timeLimit = DataGenerator.getProperty(properties, "timeLimit", 10);
    }

    public boolean computeNewRouteByComparison(int lastTime, int actTime, int origSpeed, int actSpeed) {
        if (actTime - lastTime < this.timeLimit || actSpeed > origSpeed / this.speedThreshold) {
            return false;
        }
        int randNum = Math.abs(this.random.nextInt()) % this.speedProbability;
        if (randNum > 0) {
            return false;
        }
        ++this.numOfRoutesByComparison;
        return true;
    }

    public boolean computeNewRouteByEvent(int lastTime, int actTime) {
        if (actTime - lastTime < this.timeLimit) {
            return false;
        }
        int randNum = Math.abs(this.random.nextInt()) % this.eventProbability;
        if (randNum > 0) {
            return false;
        }
        ++this.numOfRoutesByEvent;
        return true;
    }

    public int getNumberOfRoutesByComparison() {
        return this.numOfRoutesByComparison;
    }

    public int getNumberOfRoutesByEvent() {
        return this.numOfRoutesByEvent;
    }
}

