/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import drawables.DrawableObjects;
import generator2.Reporter;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;

public class NodeReporter
extends Reporter {
    protected DataOutputStream dOut = null;
    protected PrintWriter pOut = null;
    protected Vector repObjs = new Vector();

    public NodeReporter(Properties properties, DrawableObjects objects) {
        super(properties, objects);
        String name = properties.getProperty("outputFile");
        if (name != null) {
            try {
                if (name.endsWith(".mof")) {
                    this.dOut = new DataOutputStream(new FileOutputStream(name));
                } else {
                    this.pOut = new PrintWriter(new FileOutputStream(name));
                }
            }
            catch (Exception ioe) {
                System.err.println("Error occured by creating the output file " + name);
            }
        }
    }

    public void close() {
        try {
            this.reportObjects();
            if (this.dOut != null) {
                this.dOut.close();
            }
            if (this.pOut != null) {
                this.pOut.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reportDisappearingObject(double time, long id, int repNum, int objClass, int x, int y, double doneDist, int reportProbability) {
        if (reportProbability > 0) {
            this.repObjs.add(new ReportObject(2, id, objClass, time, x, y, 0.0, x, y));
        }
    }

    public void reportEdge(double time, long objId, int edgeRepNum, int objClass, long edgeId, int edgeClass, int x1, int y1, double speed, int x2, int y2, int reportProbability) {
        if (reportProbability > 0) {
            this.repObjs.add(new ReportObject(edgeRepNum == 1 ? (byte)0 : 1, objId, objClass, time, x1, y1, speed, x2, y2));
            if (edgeRepNum == 1) {
                this.reportObjects();
            }
        }
    }

    public int reportMovingObject(int time, long id, int repNum, int objClass, double x, double y, double speed, double doneDist, int nextNodeX, int nextNodeY, int reportProbability) {
        return super.reportMovingObject(time, id, repNum, objClass, x, y, speed, doneDist, nextNodeX, nextNodeY, reportProbability);
    }

    public int reportNewMovingObject(int time, long id, int objClass, int x, int y, double speed, int nextNodeX, int nextNodeY, int reportProbability) {
        return super.reportNewMovingObject(time, id, objClass, x, y, speed, nextNodeX, nextNodeY, reportProbability);
    }

    protected void reportObjects() {
        if (this.repObjs.isEmpty()) {
            return;
        }
        Object[] ro = this.repObjs.toArray();
        if (ro.length > 1) {
            Arrays.sort(ro);
        }
        int i = 0;
        while (i < ro.length) {
            ((ReportObject)ro[i]).print(this.dOut);
            ((ReportObject)ro[i]).print(this.pOut);
            ++i;
        }
        this.repObjs.clear();
    }

    protected class ReportObject
    implements Comparable {
        protected byte action;
        protected long id;
        protected int objClass;
        protected double time;
        protected int x1;
        protected int y1;
        protected double speed;
        protected int x2;
        protected int y2;

        protected ReportObject(byte action, long id, int objClass, double time, int x1, int y1, double speed, int x2, int y2) {
            this.action = action;
            this.id = id;
            this.objClass = objClass;
            this.time = time;
            this.x1 = x1;
            this.y1 = y1;
            this.speed = speed;
            this.x2 = x2;
            this.y2 = y2;
        }

        public int compareTo(Object obj) {
            try {
                ReportObject o = (ReportObject)obj;
                if (this.time < o.time) {
                    return -1;
                }
                return 1;
            }
            catch (Exception ex) {
                return 1;
            }
        }

        protected void print(PrintWriter out) {
            if (out == null) {
                return;
            }
            out.print(this.action);
            out.print('\t');
            out.print(this.id);
            out.print('\t');
            out.print(this.objClass);
            out.print('\t');
            out.print(this.time);
            out.print('\t');
            out.print(this.x1);
            out.print('\t');
            out.print(this.y1);
            out.print('\t');
            out.print(this.speed);
            out.print('\t');
            out.print(this.x2);
            out.print('\t');
            out.println(this.y2);
        }

        protected void print(DataOutputStream out) {
            if (out == null) {
                return;
            }
            try {
                out.writeByte(this.action);
                out.writeLong(this.id);
                out.writeInt(this.objClass);
                out.writeDouble(this.time);
                out.writeInt(this.x1);
                out.writeInt(this.y1);
                out.writeDouble(this.speed);
                out.writeInt(this.x2);
                out.writeInt(this.y2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

