/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.ExternalObject;
import generator2.ExternalObjectClasses;
import generator2.ExternalObjectGenerator;
import generator2.Reporter;
import generator2.Time;
import java.util.Properties;
import java.util.Vector;
import routing.Edge;
import spatial.AllQuery;
import spatial.MBR;
import spatial.MemoryRTree;
import spatial.RegionQuery;
import spatial.WindowQuery;
import util.Timer;

public class ExternalObjects {
    private Properties properties = null;
    private Time time;
    private ExternalObjectClasses objClasses;
    private MemoryRTree objs = null;
    private Vector deadObjs = new Vector(20, 20);
    private Vector moveObjs = new Vector(200, 200);
    private RegionQuery allQuery = new RegionQuery(new AllQuery());
    private RegionQuery intersectionQuery = new RegionQuery(new WindowQuery());
    private int totalNum = 0;
    private long decNum = 0L;
    private long realDecNum = 0L;

    public ExternalObjects(Properties properties, Time time, ExternalObjectClasses objClasses) {
        this.properties = properties;
        this.time = time;
        this.objClasses = objClasses;
        this.objs = new MemoryRTree();
        Timer.reset(7);
    }

    protected void add(ExternalObject obj) {
        Timer.start(7);
        this.objs.insert(obj);
        ++this.totalNum;
        Timer.stop(7);
    }

    public int computeDecrease(Edge edge) {
        Timer.start(7);
        ++this.decNum;
        if (this.objs.getTotalNumberOfObjects() == 0) {
            Timer.stop(7);
            return 100;
        }
        this.intersectionQuery.initWithRect(this.objs, new MBR(edge.getMBR()));
        int minFactor = 100;
        ExternalObject extObj = (ExternalObject)this.intersectionQuery.getNextObject();
        while (extObj != null) {
            int decF = this.objClasses.getDecreasingFactor(extObj.getObjectClass());
            if (decF < minFactor) {
                minFactor = decF;
            }
            extObj = (ExternalObject)this.intersectionQuery.getNextObject();
        }
        if (minFactor < 100) {
            ++this.realDecNum;
        }
        Timer.stop(7);
        return minFactor;
    }

    public long getNumOfComputedDecreases() {
        return this.decNum;
    }

    public long getNumOfRealDecreases() {
        return this.realDecNum;
    }

    public ExternalObjectClasses getObjectClasses() {
        return this.objClasses;
    }

    public Time getTime() {
        return this.time;
    }

    public int getTotalNumOfObjects() {
        return this.totalNum;
    }

    public long getUsedTime() {
        return Timer.get(7);
    }

    public void moveAndResizeAndRemoveObjects(int time, ExternalObjectGenerator gen, Reporter reporter) {
        ExternalObject actObj;
        Timer.start(7);
        this.allQuery.init(this.objs);
        ExternalObject extObj = (ExternalObject)this.allQuery.getNextObject();
        while (extObj != null) {
            if (!extObj.isAlive(time)) {
                this.deadObjs.addElement(extObj);
            } else {
                this.moveObjs.addElement(extObj);
            }
            extObj = (ExternalObject)this.allQuery.getNextObject();
        }
        int i = 0;
        while (i < this.deadObjs.size()) {
            actObj = (ExternalObject)this.deadObjs.elementAt(i);
            actObj.reportDeletedObject(reporter, time);
            if (!this.objs.remove(actObj)) {
                System.err.println("ext. obj. " + actObj.getMBR() + " not deleted!");
            }
            this.deadObjs.setElementAt(null, i);
            ++i;
        }
        this.deadObjs.setSize(0);
        i = 0;
        while (i < this.moveObjs.size()) {
            actObj = (ExternalObject)this.moveObjs.elementAt(i);
            MBR oldMBR = actObj.getMBR();
            MBR mbr = gen.computeNewPositionAndSize(time, actObj);
            if (mbr != oldMBR) {
                if (!oldMBR.contains(mbr, -1)) {
                    if (!this.objs.remove(actObj)) {
                        System.err.println("ext. obj. " + mbr + " not deleted (2)!");
                    } else {
                        actObj.setMBR(mbr);
                        this.objs.insert(actObj);
                    }
                } else {
                    actObj.setMBR(mbr);
                }
            }
            actObj.reportMovingObject(reporter, time);
            this.moveObjs.setElementAt(null, i);
            ++i;
        }
        this.moveObjs.setSize(0);
        Timer.stop(7);
    }

    public void removeObjects() {
        Timer.start(7);
        this.allQuery.init(this.objs);
        ExternalObject extObj = (ExternalObject)this.allQuery.getNextObject();
        while (extObj != null) {
            this.moveObjs.addElement(extObj);
            extObj = (ExternalObject)this.allQuery.getNextObject();
        }
        int i = 0;
        while (i < this.moveObjs.size()) {
            if (!this.objs.remove((ExternalObject)this.moveObjs.elementAt(i))) {
                System.err.println("ext. obj. " + ((ExternalObject)this.deadObjs.elementAt(i)).getMBR() + " not deleted!");
            }
            this.moveObjs.setElementAt(null, i);
            ++i;
        }
        this.moveObjs.setSize(0);
        this.objs = new MemoryRTree();
        Timer.stop(7);
    }
}

