/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.RandomGenerator;
import generator2.Time;
import java.awt.Color;
import java.util.Properties;
import java.util.Random;

public class ExternalObjectClasses {
    protected Properties properties;
    protected Time time;
    protected DataSpace ds;
    protected int num = 3;
    protected int[] lifetime;
    protected int[] extension;
    protected int[] decreasingFactor;
    protected final int PORTIONSUM = 1000;
    protected int[] portion;
    protected int[] beginPortion;
    protected Color[] color;
    protected Random random;

    public ExternalObjectClasses(Properties properties, Time time, DataSpace ds, int numOfClasses) {
        this.num = numOfClasses;
        this.properties = properties;
        this.time = time;
        this.ds = ds;
        this.random = RandomGenerator.get(properties);
        if (this.num == 0) {
            return;
        }
        this.extension = new int[this.num];
        this.extension[this.num - 1] = (ds.getMaxX() - ds.getMinX() + ds.getMaxY() - ds.getMinY()) / 5;
        int i = this.num - 2;
        while (i >= 0) {
            this.extension[i] = this.extension[i + 1] / 2;
            --i;
        }
        this.lifetime = new int[this.num];
        this.lifetime[this.num - 1] = 10;
        i = this.num - 2;
        while (i >= 0) {
            this.lifetime[i] = 10;
            --i;
        }
        this.decreasingFactor = new int[this.num];
        this.decreasingFactor[0] = 64;
        i = 1;
        while (i < this.num) {
            this.decreasingFactor[i] = this.decreasingFactor[i - 1] > 8 ? this.decreasingFactor[i - 1] / 2 : this.decreasingFactor[i - 1];
            ++i;
        }
        this.portion = new int[this.num];
        this.portion[0] = 500;
        i = 1;
        while (i < this.num - 1) {
            this.portion[i] = this.portion[i - 1] / 2;
            ++i;
        }
        if (this.num > 1) {
            this.portion[this.num - 1] = this.portion[this.num - 2];
        }
        this.beginPortion = new int[this.num];
        i = 0;
        while (i < this.num) {
            this.beginPortion[i] = 1000 / this.num;
            ++i;
        }
        this.color = new Color[this.num];
        this.color[0] = Color.red;
        if (this.num > 1) {
            this.color[1] = Color.blue;
        }
        if (this.num > 2) {
            this.color[2] = Color.orange;
        }
        if (this.num > 3) {
            this.color[3] = Color.magenta;
        }
        if (this.num > 4) {
            this.color[4] = Color.black;
        }
        if (this.num > 5) {
            this.color[5] = Color.green;
        }
        if (this.num > 6) {
            this.color[6] = Color.pink;
        }
        i = 7;
        while (i < this.num) {
            this.color[i] = new Color(Math.abs(RandomGenerator.getForVisualization(properties).nextInt()) % 0x1000000);
            ++i;
        }
    }

    public int computeNewExternalObjectClass(int time) {
        int value = Math.abs(this.random.nextInt()) % 1000;
        int[] p = this.portion;
        if (time == 0) {
            p = this.beginPortion;
        }
        int i = 0;
        while (i < this.num) {
            if (value - p[i] < 0) {
                return i;
            }
            value -= p[i];
            ++i;
        }
        return this.num - 1;
    }

    public Color getColor(int c) {
        if (c >= 0 && c < this.num) {
            return this.color[c];
        }
        return Color.red;
    }

    public int getDecreasingFactor(int c) {
        if (c >= 0 && c < this.num) {
            return this.decreasingFactor[c];
        }
        return 100;
    }

    public int getExtension(int c, int dim) {
        if (c >= 0 && c < this.num) {
            return this.extension[c];
        }
        return 0;
    }

    public int getLifetime(int c) {
        if (c >= 0 && c < this.num) {
            return this.lifetime[c];
        }
        return 1;
    }

    public int getNumber() {
        return this.num;
    }
}

