/*
 * Decompiled with CFR 0.152.
 */
package generator2;

import generator2.DataSpace;
import generator2.MovingObject;
import generator2.ObjectClasses;
import generator2.ObjectGenerator;
import generator2.Time;
import java.util.Properties;
import java.util.Stack;
import routing.Node;
import routing.Nodes;

public class ConstantObjectGenerator
extends ObjectGenerator {
    protected Stack deadObjs = new Stack();

    public ConstantObjectGenerator(Properties properties, Time time, DataSpace ds, Nodes nodes, ObjectClasses objClasses, int numOfObjPerTime, int numOfObjAtBeginning) {
        super(properties, time, ds, nodes, objClasses, numOfObjPerTime, numOfObjAtBeginning);
    }

    public Node computeDestinationNode(int time, Node startingNode, int length, int objClass) {
        Node dest = super.computeDestinationNode(time, startingNode, length, objClass);
        if (!Time.isFirstTimeStamp(time)) {
            this.deadObjs.pop();
        }
        return dest;
    }

    public int computeId(int currTime) {
        if (Time.isFirstTimeStamp(currTime)) {
            return super.computeId(currTime);
        }
        MovingObject obj = (MovingObject)this.deadObjs.peek();
        return obj.getId();
    }

    public int computeObjectClass(int currTime) {
        if (Time.isFirstTimeStamp(currTime)) {
            return super.computeObjectClass(currTime);
        }
        MovingObject obj = (MovingObject)this.deadObjs.peek();
        return obj.getObjectClass();
    }

    public Node computeStartingNode(int time, int objClass) {
        if (Time.isFirstTimeStamp(time)) {
            return super.computeStartingNode(time, objClass);
        }
        MovingObject obj = (MovingObject)this.deadObjs.peek();
        return obj.getDestinationNode();
    }

    public int numberOfNewObjects(int time) {
        if (Time.isFirstTimeStamp(time)) {
            return this.numOfObjAtBeginning;
        }
        return this.deadObjs.size();
    }

    public void reachDestination(MovingObject obj) {
        this.deadObjs.push(obj);
    }
}

