/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawableObject;
import drawables.DrawableObjectType;
import drawables.DrawableSymbol;
import drawables.DrawableText;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import util.DupHashtable;
import util.EntryInput;

public class DrawableObjects {
    protected int numOfLayers = 0;
    protected Drawable[] layer = null;
    protected Drawable[] lastInLayer = null;
    protected DupHashtable hashtable = null;
    public static final int STDMODE = 0;
    protected int mode = 0;
    protected int numOfModes = 1;
    protected long maxId = 0L;
    protected DrawableObject selectedObject = null;
    protected Drawable visibleDrawable = null;
    protected DrawableObject searchObject = new DrawableObject(0L, null, null, null, this);

    public DrawableObjects(int numOfLayers) {
        this.numOfLayers = numOfLayers;
        this.layer = new Drawable[numOfLayers];
        this.lastInLayer = new Drawable[numOfLayers];
        this.hashtable = new DupHashtable(5000);
    }

    public void addDrawable(Drawable prim) {
        if (prim == null) {
            return;
        }
        int l = prim.getLayer();
        if (l < 0 || l >= this.numOfLayers) {
            System.err.println("wrong layer number!");
            return;
        }
        if (this.layer[l] == null) {
            this.layer[l] = prim;
        } else {
            this.lastInLayer[l].setNextOfLayer(prim);
        }
        this.lastInLayer[l] = prim;
        prim.setContainer(this);
    }

    public void deselect() {
        if (this.selectedObject != null) {
            this.selectedObject.setSelection(false);
        }
        this.selectedObject = null;
    }

    public void drawAllObjects(Graphics g, Rectangle r, int scale) {
        int l = 0;
        while (l < this.numOfLayers) {
            this.drawAllObjectsOfLayer(l, g, r, scale);
            ++l;
        }
    }

    public void drawAllObjectsOfLayer(int l, Graphics g, Rectangle r, int scale) {
        if (l >= this.numOfLayers) {
            return;
        }
        Drawable prim = this.layer[l];
        while (prim != null) {
            prim.draw(g, r, scale);
            prim = prim.getNextOfLayer();
        }
    }

    public Enumeration elements() {
        return this.hashtable.elements();
    }

    public Drawable findNearestDrawable(int x, int y) {
        System.err.println("DrawableObjects.findNearestDrawable not implemented without search tree");
        return null;
    }

    public Rectangle getDataspace() {
        System.err.println("DrawableObjects.getDataspace not implemented without search tree");
        return null;
    }

    public int getMode() {
        return this.mode;
    }

    public Drawable getNextDrawable(Drawable prevPrim) {
        int l = 0;
        Drawable next = null;
        if (prevPrim != null) {
            next = prevPrim.getNextOfLayer();
            if (next != null) {
                return next;
            }
            l = prevPrim.getLayer() + 1;
        }
        while (l < this.numOfLayers) {
            next = this.getNextDrawableOfLayer(null, l);
            if (next != null) {
                return next;
            }
            ++l;
        }
        return null;
    }

    private Drawable getNextDrawableOfLayer(Drawable prim, int l) {
        if (prim == null) {
            if (l >= this.numOfLayers) {
                return null;
            }
            return this.layer[l];
        }
        return prim.getNextOfLayer();
    }

    public long getNextFreeId() {
        return this.maxId + 1L;
    }

    public DrawableObject getNextVisibleIntersectingObject(int px, int py, int scale, boolean selectable) {
        this.visibleDrawable = this.getNextDrawable(this.visibleDrawable);
        boolean firstSearch = true;
        while (true) {
            if (this.visibleDrawable == null) {
                if (firstSearch) {
                    this.visibleDrawable = this.getNextDrawable(null);
                    firstSearch = false;
                    continue;
                }
                return null;
            }
            if (this.visibleDrawable.isVisible(scale) && this.visibleDrawable.getObject() != null && this.visibleDrawable.getObject().getName() != null && this.visibleDrawable.getObject().getName().length() > 0 && (!selectable || this.visibleDrawable.getPresentation(scale, this.mode, this.visibleDrawable.getObject().getPresValue()).getSelectability()) && this.visibleDrawable.interacts(px, py, scale)) {
                return this.visibleDrawable.getObject();
            }
            this.visibleDrawable = this.getNextDrawable(this.visibleDrawable);
        }
    }

    public int getNumberOfModes() {
        return this.numOfModes;
    }

    public int getNumberOfObjects() {
        System.err.println("DrawableObjects.getNumberOfObjects not implemented");
        return 0;
    }

    public DrawableObject getObjectById(long id) {
        this.searchObject.setId(id);
        return (DrawableObject)this.hashtable.get(this.searchObject);
    }

    public DrawableObject getSelectedObject() {
        return this.selectedObject;
    }

    public DrawableObject getVisibleObjectById(long id, int scale) {
        this.searchObject.setId(id);
        DrawableObject obj = (DrawableObject)this.hashtable.get(this.searchObject);
        while (obj != null && !obj.isVisible(scale)) {
            obj = (DrawableObject)this.hashtable.getNext(this.searchObject);
        }
        return obj;
    }

    public DrawableObject newDrawableObject(long id, DrawableObjectType type, String name, String info) {
        DrawableObject obj = new DrawableObject(id, type, name, info, this);
        this.hashtable.put(obj, obj);
        if (id > this.maxId) {
            this.maxId = id;
        }
        return obj;
    }

    public DrawableObject newDrawableObject(long id, String typeName, String name, String info) {
        return this.newDrawableObject(id, DrawableObjectType.getObjectType(typeName), name, info);
    }

    public DrawableObject newDrawableObject(long id, String typeName, String name, String info, int defScale) {
        DrawableObject obj = this.newDrawableObject(id, DrawableObjectType.getObjectType(typeName), name, info);
        obj.setDefaultScale(defScale);
        return obj;
    }

    public DrawableObject readDrawableObject(DataInputStream r, int version) throws IOException {
        return this.newDrawableObject(r.readLong(), r.readUTF(), r.readUTF(), r.readUTF(), r.readShort());
    }

    public DrawableObject readDrawableObject(EntryInput r, int version) {
        return this.newDrawableObject(r.readLong(), r.readString(), DrawableText.correctString(r.readString()), DrawableText.correctString(r.readString()), r.eol() ? -1 : r.readInt());
    }

    public void readDrawableObject(EntryInput r, String objType) {
        if (objType == null) {
            return;
        }
        DrawableSymbol.bufferedText = null;
        Drawable prim = Drawable.readDrawable(r, objType);
        if (prim == null) {
            return;
        }
        long id = r.readLong();
        if (r.eol()) {
            this.addDrawable(prim);
            if (DrawableSymbol.bufferedText != null) {
                this.addDrawable(DrawableSymbol.bufferedText);
            }
            DrawableSymbol.bufferedText = null;
        } else {
            DrawableObject baseObj;
            DrawableObject obj = this.newDrawableObject(id, r.readString(), DrawableText.correctString(r.readString()), DrawableText.correctString(r.readString()));
            obj.addDrawable(prim);
            this.addDrawable(prim);
            if (DrawableSymbol.bufferedText != null) {
                obj.addDrawable(DrawableSymbol.bufferedText);
                this.addDrawable(DrawableSymbol.bufferedText);
                DrawableSymbol.bufferedText = null;
            } else if (objType.startsWith("S") && (baseObj = this.getObjectById(obj.getId())) != null && baseObj.getNumberOfDrawables() > 1) {
                obj.addDrawable(baseObj.getDrawable(1));
            }
        }
    }

    public void remove(DrawableObject obj) {
        if (obj == null) {
            return;
        }
        int i = 0;
        while (i < obj.getNumberOfDrawables()) {
            int l = obj.getDrawable(i).getLayer();
            if (this.layer[l] == obj.getDrawable(i)) {
                this.layer[l] = obj.getDrawable(i).getNextOfLayer();
            } else {
                Drawable prev = this.layer[l];
                while (prev != null && prev.getNextOfLayer() != obj.getDrawable(i)) {
                    prev = prev.getNextOfLayer();
                }
                if (prev != null) {
                    prev.setNextOfLayer(obj.getDrawable(i).getNextOfLayer());
                }
            }
            ++i;
        }
        this.hashtable.remove(obj);
        if (this.selectedObject == obj) {
            this.deselect();
        }
        this.visibleDrawable = null;
    }

    public void removeAll() {
        this.deselect();
        int i = 0;
        while (i < this.numOfLayers) {
            this.layer[i] = null;
            ++i;
        }
        this.hashtable = new DupHashtable(5000);
        this.visibleDrawable = null;
    }

    public void removeAllObjectsOfLayer(int l) {
        if (l < 0 || l >= this.numOfLayers) {
            return;
        }
        Drawable prim = this.layer[l];
        while (prim != null) {
            DrawableObject obj = prim.getObject();
            if (obj != null) {
                this.hashtable.remove(obj);
            }
            prim = prim.getNextOfLayer();
        }
        this.layer[l] = null;
        this.deselect();
        this.visibleDrawable = null;
    }

    public void select(DrawableObject obj) {
        if (obj == null) {
            return;
        }
        this.deselect();
        obj.setSelection(true);
        this.selectedObject = obj;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setNumberOfModes(int num) {
        this.numOfModes = num;
    }
}

