/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawablePresentation;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableLine
extends Drawable {
    public static final int UNDIRECTED = 0;
    public static final int FORWARDS = 1;
    public static final int BACKWARDS = 2;
    public static final int BOTHDIRECTIONS = 3;
    public static final int NORMALTYPE = 0;
    public static final int SPLITTED = 1;
    private int x1 = 0;
    private int y1 = 0;
    private int x2 = 0;
    private int y2 = 0;
    private byte selected = 0;

    protected DrawableLine() {
    }

    public DrawableLine(int px1, int py1, int px2, int py2) {
        this.x1 = px1;
        this.y1 = py1;
        this.x2 = px2;
        this.y2 = py2;
        this.mbr = new Rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1 + 1), Math.abs(this.y2 - this.y1 + 1));
        this.pres = DrawablePresentation.get("default");
    }

    public DrawableLine(int px1, int py1, int px2, int py2, String presName) {
        this(px1, py1, px2, py2);
        this.pres = DrawablePresentation.get(presName);
    }

    public DrawableLine(int px1, int py1, int px2, int py2, String presName, int pMinScale, int pMaxScale) {
        this(px1, py1, px2, py2, presName);
        this.minScale = pMinScale;
        this.maxScale = pMaxScale;
    }

    public void changePoint1(int x, int y) {
        this.x1 = x;
        this.y1 = y;
        this.mbr = new Rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
    }

    public void changePoint2(int x, int y) {
        this.x2 = x;
        this.y2 = y;
        this.changePoint1(this.x1, this.y1);
    }

    public void deselect(int direction) {
        this.selected = (byte)(this.selected & ~direction);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        Color forwardsColor = ap.color;
        if (this.isSelected(1)) {
            forwardsColor = ap.selectionColor;
        }
        Color backwardsColor = ap.color;
        if (this.isSelected(2)) {
            backwardsColor = ap.selectionColor;
        }
        int cx1 = this.x1 / scale;
        int cy1 = this.y1 / scale;
        int cx2 = this.x2 / scale;
        int cy2 = this.y2 / scale;
        DrawableLine.drawProtected(g, ap, forwardsColor, backwardsColor, cx1, cy1, cx2, cy2);
    }

    public static void drawProtected(Graphics g, DrawablePresentation ap, Color forwardsColor, Color backwardsColor, int cx1, int cy1, int cx2, int cy2) {
        block9: {
            int startIndex = 0;
            if (ap.type == 0) {
                g.setColor(forwardsColor);
                g.drawLine(cx1, cy1, cx2, cy2);
                startIndex = 1;
            }
            if (ap.size <= 1 && ap.type != 1) break block9;
            Color c1 = forwardsColor;
            Color c2 = forwardsColor;
            if (Math.abs(cy2 - cy1) > Math.abs(cx2 - cx1)) {
                if (cy2 < cy1) {
                    c2 = backwardsColor;
                } else {
                    c1 = backwardsColor;
                }
                int i = startIndex;
                while (i < ap.size) {
                    g.setColor(c1);
                    g.drawLine(cx1 + i + ap.offset, cy1, cx2 + i + ap.offset, cy2);
                    g.setColor(c2);
                    g.drawLine(cx1 - i - ap.offset, cy1, cx2 - i - ap.offset, cy2);
                    ++i;
                }
            } else {
                if (cx2 < cx1) {
                    c1 = backwardsColor;
                } else {
                    c2 = backwardsColor;
                }
                int i = startIndex;
                while (i < ap.size) {
                    g.setColor(c1);
                    g.drawLine(cx1, cy1 + i + ap.offset, cx2, cy2 + i + ap.offset);
                    g.setColor(c2);
                    g.drawLine(cx1, cy1 - i - ap.offset, cx2, cy2 - i - ap.offset);
                    ++i;
                }
            }
        }
    }

    public int getX1() {
        return this.x1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY1() {
        return this.y1;
    }

    public int getY2() {
        return this.y2;
    }

    public boolean interacts(int x, int y, int scale) {
        return DrawableLine.interacts(x, y, this.x1, this.y1, this.x2, this.y2, this.mbr.x, this.mbr.y, this.mbr.x + this.mbr.width - 1, this.mbr.y + this.mbr.height - 1, scale);
    }

    public static boolean interacts(int x, int y, int x1, int y1, int x2, int y2, int mx1, int my1, int mx2, int my2, int scale) {
        if (x < mx1 - 2 * scale || x > mx2 + 2 * scale || y < my1 - 2 * scale || y > my2 + 2 * scale) {
            return false;
        }
        if (x1 == x2 || y1 == y2) {
            return true;
        }
        if (mx2 - mx1 >= my2 - my1) {
            int ny = (x - x1) * (y2 - y1) / (x2 - x1) + y1;
            return Math.abs(ny - y) < 3 * scale;
        }
        int nx = (y - y1) * (x2 - x1) / (y2 - y1) + x1;
        return Math.abs(nx - x) < 3 * scale;
    }

    public Point intersects(DrawableLine line) {
        long d;
        long c;
        int y22;
        int x21 = line.getX1();
        int x22 = line.getX2();
        long a = this.x1 - this.x2;
        int y21 = line.getY1();
        long b = y21 - (y22 = line.getY2());
        long denom = a * b - (c = (long)(this.y1 - this.y2)) * (d = (long)(x21 - x22));
        if (denom == 0L) {
            return null;
        }
        long e = this.x1 - x21;
        long f = this.y1 - y21;
        long t1nom = e * b - f * d;
        if (t1nom < 0L && denom > 0L || t1nom > 0L && denom < 0L) {
            return null;
        }
        if (Math.abs(denom) < Math.abs(t1nom)) {
            return null;
        }
        long t2nom = e * c - f * a;
        if (t2nom < 0L && denom > 0L || t2nom > 0L && denom < 0L) {
            return null;
        }
        if (Math.abs(denom) < Math.abs(t2nom)) {
            return null;
        }
        int px = (int)((long)this.x1 + -t1nom * a / denom);
        int py = (int)((long)this.y1 + -t1nom * c / denom);
        return new Point(px, py);
    }

    public boolean isSelected() {
        return this.selected > 0;
    }

    public boolean isSelected(int direction) {
        return (this.selected & direction) > 0;
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        this.x1 = r.readInt();
        this.y1 = r.readInt();
        this.x2 = r.readInt();
        this.y2 = r.readInt();
        this.mbr = new Rectangle(Math.min(this.x1, this.x2), Math.min(this.y1, this.y2), Math.abs(this.x2 - this.x1), Math.abs(this.y2 - this.y1));
        if (type == 0) {
            this.pres = DrawablePresentation.get("default");
            return this;
        }
        this.pres = DrawablePresentation.get(r.readString());
        if (type == 1) {
            return this;
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        return this;
    }

    public void select(int direction) {
        this.selected = (byte)(this.selected | direction);
    }

    public void setSelection(boolean on) {
        this.selected = on ? (byte)3 : (byte)0;
    }

    public Point touches(int x, int y, int tolerance) {
        if (x < this.mbr.x - tolerance || x > this.mbr.x + this.mbr.width + tolerance || y < this.mbr.y - tolerance || y > this.mbr.y + this.mbr.height + tolerance) {
            return null;
        }
        if (this.x1 == this.x2) {
            return new Point(this.x1, y);
        }
        if (this.y1 == this.y2) {
            return new Point(x, this.y1);
        }
        if (this.mbr.width >= this.mbr.height) {
            int ny = (x - this.x1) * (this.y2 - this.y1) / (this.x2 - this.x1) + this.y1;
            if (Math.abs(ny - y) <= tolerance) {
                return new Point(x, ny);
            }
            return null;
        }
        int nx = (y - this.y1) * (this.x2 - this.x1) / (this.y2 - this.y1) + this.x1;
        if (Math.abs(nx - x) <= tolerance) {
            return new Point(nx, y);
        }
        return null;
    }

    public void writeGML(EntryWriter out) {
        String name = "line_";
        if (this.obj != null) {
            name = String.valueOf(name) + this.obj.getName();
        }
        out.println("<LineString name=\"" + name + "\" srsName=\"br\">");
        out.print(" <CList>" + this.x1 + "," + this.y1 + " " + this.x2 + "," + this.y2 + "</CList>");
        out.println("</LineString>");
    }

    protected void writeProtected(EntryWriter out, int type) {
        out.print("Line\t" + type + '\t');
        out.print(this.x1);
        out.print('\t');
        out.print(this.y1);
        out.print('\t');
        out.print(this.x2);
        out.print('\t');
        out.print(this.y2);
        out.print('\t');
        if (type == 0) {
            return;
        }
        out.print(String.valueOf(this.pres.getName()) + '\t');
        if (type == 1) {
            return;
        }
        out.print(this.minScale);
        out.print('\t');
        out.print(this.maxScale);
        out.print('\t');
    }
}

