/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.DrawablePresentation;
import drawables.DrawableRectangle;
import java.awt.Graphics;
import java.awt.Rectangle;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableCircle
extends DrawableRectangle {
    protected DrawableCircle() {
    }

    public DrawableCircle(int x, int y, int rad) {
        super(x - rad, y - rad, x + rad, y + rad);
    }

    public DrawableCircle(int x, int y, int rad, boolean pFilled, String presName) {
        super(x - rad, y - rad, x + rad, y + rad, pFilled, presName);
    }

    public DrawableCircle(int x, int y, int rad, boolean pFilled, String presName, int pMinScale, int pMaxScale) {
        super(x - rad, y - rad, x + rad, y + rad, pFilled, presName, pMinScale, pMaxScale);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        DrawablePresentation ap = this.pres.get(scale, mode, value);
        if (this.filled && this.selected && ap.selectionFillColor != null) {
            g.setColor(ap.selectionFillColor);
            g.fillOval(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
        if (this.filled && !this.selected && ap.fillColor != null) {
            g.setColor(ap.fillColor);
            g.fillOval(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
        if (this.selected && ap.selectionColor != null) {
            g.setColor(ap.selectionColor);
            g.drawOval(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        } else if (ap.color != null) {
            g.setColor(ap.color);
            g.drawOval(this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale);
        }
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        int x = r.readInt();
        int y = r.readInt();
        int rad = r.readInt();
        this.mbr = new Rectangle(x - rad, y - rad, x + rad, y + rad);
        if (type == 0) {
            this.pres = DrawablePresentation.get("default");
            return this;
        }
        int f = r.readInt();
        this.filled = f != 0;
        this.pres = DrawablePresentation.get(r.readString());
        if (this.filled) {
            this.layer = 0;
        }
        if (type == 1) {
            return this;
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        return this;
    }

    protected void writeProtected(EntryWriter out, int type) {
        out.print("Circle\t" + type + '\t');
        int x = this.mbr.x + this.mbr.width / 2;
        int y = this.mbr.y + this.mbr.height / 2;
        int rad = this.mbr.width / 2;
        out.print(x);
        out.print('\t');
        out.print(y);
        out.print('\t');
        out.print(rad);
        out.print('\t');
        if (type == 0) {
            return;
        }
        if (this.filled) {
            out.print("1\t");
        } else {
            out.print("0\t");
        }
        out.print(String.valueOf(this.pres.getName()) + '\t');
        if (type == 1) {
            return;
        }
        out.print(this.minScale);
        out.print('\t');
        out.print(this.maxScale);
        out.print('\t');
    }
}

