/*
 * Decompiled with CFR 0.152.
 */
package drawables;

import drawables.Drawable;
import drawables.DrawablePresentation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import util.EntryInput;
import util.EntryReadable;
import util.EntryWriter;

public class DrawableBitmap
extends Drawable {
    private static ImageObserver observer = null;
    private Image image = null;
    private boolean scalable = false;

    protected DrawableBitmap() {
        this.layer = (byte)4;
        this.pres = DrawablePresentation.get("default");
    }

    public DrawableBitmap(int x, int y, int width, int height, URL url, String presName, boolean scalable) {
        this();
        this.mbr = new Rectangle(x, y, width, height);
        this.image = Toolkit.getDefaultToolkit().getImage(url);
        this.pres = DrawablePresentation.get(presName);
        this.scalable = scalable;
        if (scalable) {
            this.layer = 0;
        }
    }

    public DrawableBitmap(int x, int y, int width, int height, URL url, String presName, boolean scalable, int minScale, int maxScale) {
        this(x, y, width, height, url, presName, scalable);
        this.minScale = minScale;
        this.maxScale = maxScale;
    }

    public DrawableBitmap(int x, int y, DrawableBitmap master) {
        this();
        this.mbr = new Rectangle(x, y, master.mbr.width, master.mbr.height);
        this.image = master.image;
        this.scalable = master.scalable;
        this.layer = master.layer;
        this.minScale = master.minScale;
        this.maxScale = master.maxScale;
        this.pres = master.pres;
    }

    public DrawableBitmap(int x, int y, URL url) {
        this(x, y, 1, 1, url, "default", false);
    }

    protected void drawProtected(Graphics g, int scale, int mode, int value) {
        if (this.scalable) {
            g.drawImage(this.image, this.mbr.x / scale, this.mbr.y / scale, this.mbr.width / scale, this.mbr.height / scale, observer);
        } else {
            g.drawImage(this.image, this.mbr.x / scale, this.mbr.y / scale, observer);
        }
    }

    public static void init(ImageObserver newObserver) {
        observer = newObserver;
    }

    public EntryReadable read(EntryInput r) {
        int type = r.readInt();
        int x = r.readInt();
        int y = r.readInt();
        String urlName = r.readString();
        if (type == 0) {
            try {
                return new DrawableBitmap(x, y, new URL(urlName));
            }
            catch (Exception e) {
                return null;
            }
        }
        int width = r.readInt();
        int height = r.readInt();
        String presName = r.readString();
        int scale = r.readInt();
        boolean bl = this.scalable = scale != 0;
        if (type == 1) {
            try {
                return new DrawableBitmap(x, y, width, height, new URL(urlName), presName, this.scalable);
            }
            catch (Exception e) {
                return null;
            }
        }
        this.minScale = r.readInt();
        this.maxScale = r.readInt();
        try {
            return new DrawableBitmap(x, y, width, height, new URL(urlName), presName, this.scalable, this.minScale, this.maxScale);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void writeProtected(EntryWriter out, int type) {
        System.err.println("DrawableBitmap: write not implemented yet");
    }
}

