/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.XArray;
import org.geotools.util.WeakCollectionCleaner;

public class WeakHashSet
extends AbstractSet {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private Entry[] table = new Entry[7];
    private int count;
    private int threshold = Math.round((float)this.table.length * 0.75f);
    private long lastRehashTime = System.currentTimeMillis();
    private static final long HOLD_TIME = 20000L;
    private static final int REMOVE = -1;
    private static final int GET = 0;
    private static final int ADD = 1;
    private static final int INTERN = 2;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geotools.util.WeakHashSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private synchronized void removeEntry(Entry toRemove) {
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError(this.count);
        }
        int i = toRemove.index;
        if (i < this.table.length) {
            Entry prev = null;
            Entry e = this.table[i];
            while (e != null) {
                if (e == toRemove) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.table[i] = e.next;
                    }
                    --this.count;
                    if (!$assertionsDisabled && !this.valid()) {
                        throw new AssertionError();
                    }
                    if (this.count <= this.threshold / 4) {
                        this.rehash(false);
                    }
                    return;
                }
                prev = e;
                e = e.next;
            }
        }
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
    }

    private void rehash(boolean augmentation) {
        Level level;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
        long currentTime = System.currentTimeMillis();
        int capacity = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (augmentation ? capacity <= this.table.length : capacity >= this.table.length || currentTime - this.lastRehashTime < 20000L) {
            return;
        }
        this.lastRehashTime = currentTime;
        Entry[] oldTable = this.table;
        this.table = new Entry[capacity];
        this.threshold = Math.round((float)capacity * 0.75f);
        int i = 0;
        while (i < oldTable.length) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                Object obj_e = e.get();
                if (obj_e != null) {
                    int index;
                    e.index = index = (obj_e.hashCode() & Integer.MAX_VALUE) % this.table.length;
                    e.next = this.table[index];
                    this.table[index] = e;
                    continue;
                }
                --this.count;
            }
            ++i;
        }
        Logger logger = Logger.getLogger("org.geotools.util");
        if (logger.isLoggable(level = Level.FINEST)) {
            LogRecord record = new LogRecord(level, "Rehash from " + oldTable.length + " to " + this.table.length);
            record.setSourceMethodName(augmentation ? "canonicalize" : "remove");
            record.setSourceClassName("WeakHashSet");
            logger.log(record);
        }
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
    }

    private boolean valid() {
        int n = 0;
        int i = 0;
        while (i < this.table.length) {
            Entry e = this.table[i];
            while (e != null) {
                ++n;
                e = e.next;
            }
            ++i;
        }
        if (n != this.count) {
            this.count = n;
            return false;
        }
        return true;
    }

    public synchronized int size() {
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
        return this.count;
    }

    public boolean contains(Object obj) {
        return obj == null || this.get(obj) != null;
    }

    public synchronized Object get(Object obj) {
        return this.intern(obj, 0);
    }

    public synchronized boolean remove(Object obj) {
        return this.intern(obj, -1) != null;
    }

    public synchronized boolean add(Object obj) {
        return this.intern(obj, 1) == null;
    }

    private Object intern(Object obj, int operation) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !WeakCollectionCleaner.DEFAULT.isAlive()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError(this.count);
        }
        if (obj != null) {
            int hash = obj.hashCode() & Integer.MAX_VALUE;
            int index = hash % this.table.length;
            Entry e = this.table[index];
            while (e != null) {
                Object candidate = e.get();
                if (candidate != null && candidate.equals(obj)) {
                    if (operation == -1) {
                        e.clear();
                    }
                    return candidate;
                }
                e = e.next;
            }
            if (operation >= 1) {
                if (this.count >= this.threshold) {
                    this.rehash(true);
                    index = hash % this.table.length;
                }
                this.table[index] = new Entry(obj, this.table[index], index);
                ++this.count;
            }
        }
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
        return operation == 2 ? obj : null;
    }

    public synchronized Object canonicalize(Object object) {
        return this.intern(object, 2);
    }

    public synchronized void canonicalize(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            objects[i] = this.intern(objects[i], 2);
            ++i;
        }
    }

    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    public synchronized Object[] toArray() {
        if (!$assertionsDisabled && !this.valid()) {
            throw new AssertionError();
        }
        Object[] elements = new Object[this.count];
        int index = 0;
        int i = 0;
        while (i < this.table.length) {
            Entry el = this.table[i];
            while (el != null) {
                elements[index] = el.get();
                if (elements[index] != null) {
                    ++index;
                }
                el = el.next;
            }
            ++i;
        }
        return XArray.resize(elements, index);
    }

    public Iterator iterator() {
        return Arrays.asList(this.toArray()).iterator();
    }

    private final class Entry
    extends WeakReference {
        Entry next;
        int index;

        Entry(Object obj, Entry next, int index) {
            super(obj, WeakCollectionCleaner.DEFAULT.referenceQueue);
            this.next = next;
            this.index = index;
        }

        public void clear() {
            super.clear();
            WeakHashSet.this.removeEntry(this);
        }
    }
}

