/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DisjointSet
extends AbstractSet {
    private final Map map;
    private final DisjointSet trash;

    public DisjointSet() {
        this(false);
    }

    public DisjointSet(boolean hasTrash) {
        this.map = new LinkedHashMap();
        this.trash = hasTrash ? new DisjointSet(this.map) : null;
    }

    public DisjointSet(DisjointSet disjointSet) {
        this.map = disjointSet.map;
        this.trash = disjointSet.trash;
    }

    private DisjointSet(Map map) {
        this.map = map;
        this.trash = null;
    }

    public Set getTrash() {
        return this.trash;
    }

    public int size() {
        Map map = this.map;
        synchronized (map) {
            int count = 0;
            Iterator it = this.map.values().iterator();
            while (it.hasNext()) {
                if (it.next() != this) continue;
                ++count;
            }
            return count;
        }
    }

    public boolean contains(Object element) {
        Map map = this.map;
        synchronized (map) {
            return this.map.get(element) == this;
        }
    }

    public boolean add(Object element) {
        Map map = this.map;
        synchronized (map) {
            return this.map.put(element, this) != this;
        }
    }

    public boolean remove(Object element) {
        Map map = this.map;
        synchronized (map) {
            if (this.map.get(element) != this) {
                return false;
            }
            if (this.trash != null) {
                return this.map.put(element, this.trash) != this.trash;
            }
            return this.map.remove(element) != null;
        }
    }

    public boolean containsAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.containsAll(c);
        }
    }

    public boolean addAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.addAll(c);
        }
    }

    public boolean removeAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.removeAll(c);
        }
    }

    public boolean retainAll(Collection c) {
        Map map = this.map;
        synchronized (map) {
            return super.retainAll(c);
        }
    }

    public void clear() {
        Map map = this.map;
        synchronized (map) {
            super.clear();
        }
    }

    public Iterator iterator() {
        Map map = this.map;
        synchronized (map) {
            return new Iter();
        }
    }

    public Object[] toArray() {
        Map map = this.map;
        synchronized (map) {
            return super.toArray();
        }
    }

    public Object[] toArray(Object[] a) {
        Map map = this.map;
        synchronized (map) {
            return super.toArray(a);
        }
    }

    public String toString() {
        Map map = this.map;
        synchronized (map) {
            return super.toString();
        }
    }

    public int hashCode() {
        Map map = this.map;
        synchronized (map) {
            return super.hashCode();
        }
    }

    public boolean equals(Object set) {
        Map map = this.map;
        synchronized (map) {
            return super.equals(set);
        }
    }

    private final class Iter
    implements Iterator {
        private final Iterator iterator;
        private Map.Entry prefetch;
        private Map.Entry toRemove;

        Iter() {
            this.iterator = DisjointSet.this.map.entrySet().iterator();
        }

        private Map.Entry prefetch() {
            this.toRemove = null;
            if (this.prefetch == null) {
                while (this.iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)this.iterator.next();
                    if (next.getValue() != DisjointSet.this) continue;
                    this.prefetch = next;
                    break;
                }
            }
            return this.prefetch;
        }

        public boolean hasNext() {
            return this.prefetch() != null;
        }

        public Object next() {
            this.toRemove = this.prefetch();
            this.prefetch = null;
            if (this.toRemove != null) {
                return this.toRemove.getKey();
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.toRemove != null) {
                if (DisjointSet.this.trash != null) {
                    this.toRemove.setValue(DisjointSet.this.trash);
                } else {
                    this.iterator.remove();
                }
            } else {
                throw new IllegalStateException();
            }
            this.toRemove = null;
        }
    }
}

