/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.geotools.resources.Utilities;
import org.geotools.units.Prefix;
import org.geotools.units.Unit;
import org.geotools.util.WeakHashSet;

public abstract class UnitTransform
implements Serializable {
    private static final long serialVersionUID = 59496814325077015L;
    private static final WeakHashSet pool = Prefix.pool;
    public final Unit fromUnit;
    public final Unit toUnit;

    UnitTransform(Unit fromUnit, Unit toUnit) {
        this.fromUnit = fromUnit;
        this.toUnit = toUnit;
    }

    public boolean isIdentity() {
        return this.toUnit.equalsIgnoreSymbol(this.fromUnit);
    }

    public abstract double convert(double var1);

    public void convert(double[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = this.convert(values[i]);
            ++i;
        }
    }

    public void convert(float[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = (float)this.convert(values[i]);
            ++i;
        }
    }

    public abstract double inverseConvert(double var1);

    public void inverseConvert(double[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = this.inverseConvert(values[i]);
            ++i;
        }
    }

    public void inverseConvert(float[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = (float)this.inverseConvert(values[i]);
            ++i;
        }
    }

    final UnitTransform intern() {
        return (UnitTransform)pool.canonicalize(this);
    }

    public boolean equals(Object o) {
        if (o != null && this.getClass().equals(o.getClass())) {
            UnitTransform ut = (UnitTransform)o;
            return this.fromUnit.equals(ut.fromUnit) && this.toUnit.equals(ut.toUnit);
        }
        return false;
    }

    public int hashCode() {
        return this.fromUnit.hashCode() ^ this.toUnit.hashCode();
    }

    public String toString() {
        return String.valueOf(Utilities.getShortClassName(this)) + '[' + this.fromUnit + " --> " + this.toUnit + ']';
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }
}

