/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.geotools.resources.Utilities;
import org.geotools.units.BaseUnit;
import org.geotools.units.DerivedUnit;
import org.geotools.units.Factor;
import org.geotools.units.OffsetUnit;
import org.geotools.units.Prefix;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledUnit;
import org.geotools.units.SimpleUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitTransform;

final class UnitSet
implements Serializable {
    private static final long serialVersionUID = -7375402196770611553L;
    public static final String PATHNAME = "org/geotools/units/database.serialized";
    private final PrefixSet prefix;
    private final Unit[] units;

    private UnitSet() {
        PrefixSet ALL = this.prefix = PrefixSet.getPrefixSet(new Prefix[]{Prefix.getPrefix("yocto", "y", 1.0E-24), Prefix.getPrefix("zepto", "z", 1.0E-21), Prefix.getPrefix("atto", "a", 1.0E-18), Prefix.getPrefix("femto", "f", 1.0E-15), Prefix.getPrefix("pico", "p", 1.0E-12), Prefix.getPrefix("nano", "n", 1.0E-9), Prefix.getPrefix("micro", "\u00b5", 1.0E-6), Prefix.getPrefix("milli", "m", 0.001), Prefix.getPrefix("centi", "c", 0.01), Prefix.getPrefix("deci", "d", 0.1), Prefix.getPrefix("", "", 1.0), Prefix.getPrefix("deca", "da", 10.0), Prefix.getPrefix("hecto", "h", 100.0), Prefix.getPrefix("kilo", "k", 1000.0), Prefix.getPrefix("mega", "M", 1000000.0), Prefix.getPrefix("giga", "G", 1.0E9), Prefix.getPrefix("tera", "T", 1.0E12), Prefix.getPrefix("peta", "P", 1.0E15), Prefix.getPrefix("exa", "E", 1.0E18), Prefix.getPrefix("zetta", "Z", 1.0E21), Prefix.getPrefix("yotta", "Y", 1.0E24)});
        PrefixSet NONE = null;
        BaseUnit METRE = BaseUnit.getInstance("length", "m", ALL);
        BaseUnit KILOGRAM = BaseUnit.getInstance("mass", "kg", ALL);
        BaseUnit SECOND = BaseUnit.getInstance("time", "s", ALL);
        BaseUnit AMPERE = BaseUnit.getInstance("electric current", "A", ALL);
        BaseUnit KELVIN = BaseUnit.getInstance("thermodynamic temperature", "K", ALL);
        BaseUnit MOLE = BaseUnit.getInstance("amount of substance", "mol", ALL);
        BaseUnit CANDELA = BaseUnit.getInstance("luminous intensity", "cd", ALL);
        BaseUnit RADIAN = BaseUnit.getInstance("plane angle", "rad", NONE);
        BaseUnit STERADIAN = BaseUnit.getInstance("solid angle", "sr", NONE);
        BaseUnit PSS78 = BaseUnit.getInstance("salinity", "PSS78", NONE);
        SimpleUnit METRE2 = DerivedUnit.getInstance("area", "m\u00b2", NONE, new Factor[]{Factor.getFactor(METRE, 2)});
        SimpleUnit METRE3 = DerivedUnit.getInstance("volume", "m\u00b3", NONE, new Factor[]{Factor.getFactor(METRE, 3)});
        SimpleUnit METRE_PER_SECOND = DerivedUnit.getInstance("speed", "m/s", NONE, new Factor[]{Factor.getFactor(METRE, 1), Factor.getFactor(SECOND, -1)});
        SimpleUnit METRE_PER_SECOND2 = DerivedUnit.getInstance("acceleration", "m/s\u00b2", NONE, new Factor[]{Factor.getFactor(METRE, 1), Factor.getFactor(SECOND, -2)});
        SimpleUnit METRE2_PER_SECOND = DerivedUnit.getInstance(null, "m\u00b2/s", NONE, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(SECOND, -1)});
        SimpleUnit PASCAL_SECOND = DerivedUnit.getInstance(null, "Pa\u00b7s", NONE, new Factor[]{Factor.getFactor(KILOGRAM, 1), Factor.getFactor(METRE, -1), Factor.getFactor(SECOND, -1)});
        SimpleUnit AMPERE_PER_METRE = DerivedUnit.getInstance("magnetic field strength", "A/m", NONE, new Factor[]{Factor.getFactor(METRE, -1), Factor.getFactor(AMPERE, 1)});
        SimpleUnit COULOMB_PER_KILOGRAM = DerivedUnit.getInstance(null, "C/kg", NONE, new Factor[]{Factor.getFactor(KILOGRAM, -1), Factor.getFactor(SECOND, 1), Factor.getFactor(AMPERE, 1)});
        SimpleUnit CANDELA_PER_METRE2 = DerivedUnit.getInstance("luminance", "cd/m\u00b2", NONE, new Factor[]{Factor.getFactor(METRE, -2), Factor.getFactor(CANDELA, 1)});
        SimpleUnit WATT_SECOND_PER_METRE2 = DerivedUnit.getInstance(null, "W/(m\u00b2\u00b7Hz)", NONE, new Factor[]{Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2)});
        SimpleUnit HERTZ = DerivedUnit.getInstance("frequency", "Hz", ALL, new Factor[]{Factor.getFactor(SECOND, -1)});
        SimpleUnit NEWTON = DerivedUnit.getInstance("force", "N", ALL, new Factor[]{Factor.getFactor(METRE, 1), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2)});
        SimpleUnit PASCAL = DerivedUnit.getInstance("pressure", "Pa", ALL, new Factor[]{Factor.getFactor(KILOGRAM, 1), Factor.getFactor(METRE, -1), Factor.getFactor(SECOND, -2)});
        SimpleUnit JOULE = DerivedUnit.getInstance("energy", "J", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2)});
        SimpleUnit WATT = DerivedUnit.getInstance("power", "W", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -3)});
        SimpleUnit COULOMB = DerivedUnit.getInstance("electric charge", "C", ALL, new Factor[]{Factor.getFactor(SECOND, 1), Factor.getFactor(AMPERE, 1)});
        SimpleUnit VOLT = DerivedUnit.getInstance("potential", "V", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -3), Factor.getFactor(AMPERE, -1)});
        SimpleUnit FARAD = DerivedUnit.getInstance("capacitance", "F", ALL, new Factor[]{Factor.getFactor(METRE, -2), Factor.getFactor(KILOGRAM, -1), Factor.getFactor(SECOND, 4), Factor.getFactor(AMPERE, 2)});
        SimpleUnit OHM = DerivedUnit.getInstance("resistance", "\u03a9", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -3), Factor.getFactor(AMPERE, -2)});
        SimpleUnit SIEMMENS = DerivedUnit.getInstance("conductance", "S", ALL, new Factor[]{Factor.getFactor(METRE, -2), Factor.getFactor(KILOGRAM, -1), Factor.getFactor(SECOND, 3), Factor.getFactor(AMPERE, 2)});
        SimpleUnit WEBER = DerivedUnit.getInstance("magnetic flux", "Wb", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2), Factor.getFactor(AMPERE, -1)});
        SimpleUnit TESLA = DerivedUnit.getInstance("magnetic flux density", "T", ALL, new Factor[]{Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2), Factor.getFactor(AMPERE, -1)});
        SimpleUnit HENRY = DerivedUnit.getInstance("inductance", "H", ALL, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(KILOGRAM, 1), Factor.getFactor(SECOND, -2), Factor.getFactor(AMPERE, -2)});
        SimpleUnit LUMEN = DerivedUnit.getInstance("luminous flux", "lm", NONE, new Factor[]{Factor.getFactor(CANDELA, 1), Factor.getFactor(STERADIAN, 1)});
        SimpleUnit LUX = DerivedUnit.getInstance("illuminance", "lx", NONE, new Factor[]{Factor.getFactor(METRE, -2), Factor.getFactor(CANDELA, 1), Factor.getFactor(STERADIAN, 1)});
        SimpleUnit BECQUEREL = DerivedUnit.getInstance("activity", "Bq", NONE, new Factor[]{Factor.getFactor(SECOND, -1)});
        SimpleUnit GRAY = DerivedUnit.getInstance("absorbed dose", "Gy", NONE, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(SECOND, -2)});
        SimpleUnit SIEVERT = DerivedUnit.getInstance("dose equivalent", "Sv", NONE, new Factor[]{Factor.getFactor(METRE, 2), Factor.getFactor(SECOND, -2)});
        this.units = new Unit[]{METRE, KILOGRAM, SECOND, AMPERE, KELVIN, MOLE, CANDELA, RADIAN, STERADIAN, PSS78, HERTZ, NEWTON, PASCAL, JOULE, WATT, COULOMB, VOLT, FARAD, OHM, SIEMMENS, WEBER, TESLA, HENRY, LUMEN, LUX, BECQUEREL, GRAY, SIEVERT, ScaledUnit.getInstance(60.0, SECOND, "min", NONE), ScaledUnit.getInstance(3600.0, SECOND, "h", NONE), ScaledUnit.getInstance(86400.0, SECOND, "d", NONE), ScaledUnit.getInstance(Math.PI / 180, RADIAN, "\u00b0", NONE), ScaledUnit.getInstance(2.908882086657216E-4, RADIAN, "'", NONE), ScaledUnit.getInstance(4.84813681109536E-6, RADIAN, "\"", NONE), ScaledUnit.getInstance(0.001, METRE3, "l", ALL), ScaledUnit.getInstance(0.001, METRE3, "L", ALL), ScaledUnit.getInstance(0.001, KILOGRAM, "g", ALL), ScaledUnit.getInstance(1000.0, KILOGRAM, "t", NONE), ScaledUnit.getInstance(1.6021773349E-19, JOULE, "eV", ALL), ScaledUnit.getInstance(1.66054021E-27, KILOGRAM, "u", NONE), ScaledUnit.getInstance(1.495978706913E11, METRE, "ua", NONE), ScaledUnit.getInstance(0.0254, METRE, "inch", NONE), ScaledUnit.getInstance(0.3048, METRE, "foot", NONE), ScaledUnit.getInstance(0.9144, METRE, "yard", NONE), ScaledUnit.getInstance(1.8288, METRE, "fathom", NONE), ScaledUnit.getInstance(1.624, METRE, "brasse", NONE), ScaledUnit.getInstance(1609.0, METRE, "mile", NONE), ScaledUnit.getInstance(1852.0, METRE, "nmile", NONE), ScaledUnit.getInstance(0.5144444444444445, METRE_PER_SECOND, "knot", NONE), ScaledUnit.getInstance(100.0, METRE2, "are", NONE), ScaledUnit.getInstance(10000.0, METRE2, "ha", NONE), ScaledUnit.getInstance(100000.0, PASCAL, "bar", ALL), ScaledUnit.getInstance(1.0E-10, METRE, "\u00c5", NONE), ScaledUnit.getInstance(1.0E-28, METRE2, "barn", NONE), ScaledUnit.getInstance(1.0E-7, JOULE, "erg", NONE), ScaledUnit.getInstance(1.0E-5, NEWTON, "dyn", NONE), ScaledUnit.getInstance(0.1, PASCAL_SECOND, "P", NONE), ScaledUnit.getInstance(1.0E-4, METRE2_PER_SECOND, "St", NONE), ScaledUnit.getInstance(1.0E-4, TESLA, "G", NONE), ScaledUnit.getInstance(79.57747154594767, AMPERE_PER_METRE, "Oe", NONE), ScaledUnit.getInstance(1.0E-8, WEBER, "Mx", NONE), ScaledUnit.getInstance(10000.0, CANDELA_PER_METRE2, "sb", NONE), ScaledUnit.getInstance(10000.0, LUX, "ph", NONE), ScaledUnit.getInstance(0.01, METRE_PER_SECOND2, "Gal", NONE), ScaledUnit.getInstance(3.7E10, BECQUEREL, "Ci", NONE), ScaledUnit.getInstance(2.58E-4, COULOMB_PER_KILOGRAM, "R", NONE), ScaledUnit.getInstance(0.01, GRAY, "rd", NONE), ScaledUnit.getInstance(0.01, SIEVERT, "rem", NONE), ScaledUnit.getInstance(1.0E-26, WATT_SECOND_PER_METRE2, "Jy", NONE), ScaledUnit.getInstance(133.32236842105263, PASCAL, "Torr", NONE), ScaledUnit.getInstance(101325.0, PASCAL, "atm", NONE), ScaledUnit.getInstance(0.4535, KILOGRAM, "pound", NONE), ScaledUnit.getInstance(0.02834375, KILOGRAM, "onze", NONE), OffsetUnit.getInstance(273.15, KELVIN, "\u00b0C", NONE), OffsetUnit.getInstance(459.66999999999996, ScaledUnit.getInstance(0.5555555555555556, KELVIN), "\u00b0F", NONE)};
    }

    private static void print() {
        System.out.println();
    }

    private static void print(String message, double converted, double expected) {
        System.out.print(message);
        System.out.print(Utilities.spaces(30 - message.length()));
        System.out.print(' ');
        System.out.print(converted);
        if (converted != expected) {
            System.err.print("  ERROR! expected ");
            System.err.println(expected);
            System.exit(1);
        }
        System.out.println();
    }

    private static void print(String message, Unit unit, String expected) {
        System.out.print(message);
        System.out.print(Utilities.spaces(30 - message.length()));
        System.out.print(' ');
        System.out.print(unit);
        Unit check = Unit.get(expected);
        System.out.print(Utilities.spaces(10 - unit.toString().length()));
        System.out.print(' ');
        System.out.print(check);
        if (!unit.equalsIgnoreSymbol(check)) {
            System.err.print("  ERROR! expected ");
            System.err.println(expected);
            System.exit(1);
        }
        if (unit.toString().equals(check.toString()) && unit != check) {
            System.err.println("  ERROR! intern() failed");
            System.exit(1);
        }
        System.out.println();
    }

    public static void main(String[] args) throws UnitException, IOException {
        UnitSet units = new UnitSet();
        if (args.length == 0 || !args[0].equals("silent")) {
            Unit KILOGRAM = Unit.get("kg");
            UnitSet.print("[kg].pow(2)", KILOGRAM.pow(2), "kg^2");
            UnitSet.print("[kg].scale(1E-3)", KILOGRAM.scale(0.001), "g");
            UnitSet.print("[kg].scale(1E-6)", KILOGRAM.scale(1.0E-6), "mg");
            UnitSet.print("[kg].convert(5000,[g])", KILOGRAM.convert(5000.0, Unit.get("g")), 5.0);
            UnitSet.print();
            Unit METRE = Unit.get("m");
            Unit SECOND = Unit.get("s");
            UnitSet.print("[m].pow(2)", METRE.pow(2), "m^2");
            UnitSet.print("[m]*[s]", METRE.multiply(SECOND), "m*s");
            UnitSet.print("[m]/[s]", METRE.divide(SECOND), "m/s");
            UnitSet.print("[m].scale(1000)", METRE.scale(1000.0), "km");
            UnitSet.print("[m].scale(1E-6)", METRE.scale(1.0E-6), "\u00b5m");
            UnitSet.print("[m].convert(4,[cm])", METRE.convert(4.0, Unit.get("cm")), 0.04);
            UnitSet.print();
            Unit METRE_PER_SECOND = Unit.get("m/s");
            UnitSet.print("[m/s].pow(2)", METRE_PER_SECOND.pow(2), "m\u00b2/s^2");
            UnitSet.print("[m/s]*[m]", METRE_PER_SECOND.multiply(METRE), "m^2/s");
            UnitSet.print("[m]*[m/s]", METRE.multiply(METRE_PER_SECOND), "m^2/s");
            UnitSet.print("[m/s]/[m]", METRE_PER_SECOND.divide(METRE), "s^-1");
            UnitSet.print("[m]/[m/s]", METRE.divide(METRE_PER_SECOND), "s^1");
            UnitSet.print("[m/s].convert(25,[km/s])", METRE_PER_SECOND.convert(25.0, Unit.get("km/s")), 25000.0);
            UnitSet.print();
            Unit JOULE = METRE_PER_SECOND.pow(2).multiply(KILOGRAM);
            UnitSet.print("[J]", JOULE, "J");
            Unit NEWTON = KILOGRAM.multiply(METRE_PER_SECOND).divide(SECOND);
            UnitSet.print("[N]", NEWTON, "N");
            SimpleUnit KILOGRAM_PER_SECOND = DerivedUnit.getInstance(null, null, null, new Factor[]{Factor.getFactor((BaseUnit)KILOGRAM, 3), Factor.getFactor((BaseUnit)SECOND, -1), Factor.getFactor((BaseUnit)KILOGRAM, -2), Factor.getFactor((BaseUnit)Unit.get("K"), 0)});
            UnitSet.print("[kg/s]", KILOGRAM_PER_SECOND, "kg*s^-1");
            Unit POUND_PER_SECOND = ScaledUnit.getInstance(0.4535, KILOGRAM_PER_SECOND, null, null);
            Unit MILE_PER_HOUR = Unit.get("mile/h");
            UnitSet.print();
            UnitSet.print("[mile/h].pow(2)", MILE_PER_HOUR.pow(2), "mile\u00b2/h\u00b2");
            UnitSet.print("[pound/s]", POUND_PER_SECOND, "pound/s");
            UnitSet.print("[mile/h]*[pound/s]", MILE_PER_HOUR.multiply(POUND_PER_SECOND), "(mile*pound)/(h*s)");
            UnitSet.print("[pound/s]*[mile/h]", POUND_PER_SECOND.multiply(MILE_PER_HOUR), "(pound/s)*(mile/h)");
            UnitSet.print("[mile/h]/[pound/s]", MILE_PER_HOUR.divide(POUND_PER_SECOND), "(mile/h)/(pound/s)");
            UnitSet.print("[pound/s]/[mile/h]", POUND_PER_SECOND.divide(MILE_PER_HOUR), "(pound/s)/(mile/h)");
            UnitSet.print("[mile/h].convert(1,[m/s])", MILE_PER_HOUR.convert(1.0, METRE_PER_SECOND), 2.237414543194531);
            UnitSet.print("[m/s].convert(1,[mile/h])", METRE_PER_SECOND.convert(1.0, MILE_PER_HOUR), 0.4469444444444444);
            UnitSet.print();
            UnitSet.print("[min].convert(0.01,[Hz])", Unit.get("min").convert(0.01, Unit.get("Hz")), 1.6666666666666667);
            UnitSet.print("[S].convert(50,[\u03a9])", Unit.get("S").convert(50.0, Unit.get("\u03a9")), 0.02);
            UnitSet.print();
            UnitSet.print("[\u00b0F].convert(0,[\u00b0C])", Unit.get("\u00b0F").convert(0.0, Unit.get("\u00b0C")), 32.0);
            UnitSet.print("[\u00b0C].convert(32,[\u00b0F])", Unit.get("\u00b0C").convert(32.0, Unit.get("\u00b0F")), 0.0);
            UnitSet.print();
            UnitTransform transform = Unit.get("\u00b0C").getTransform(Unit.get("\u00b0F"));
            System.out.print(transform);
            System.out.print(" 38 ==> ");
            System.out.println(transform.convert(38.0));
            System.out.print(transform);
            System.out.print(" 27 ==> ");
            System.out.println(transform.convert(27.0));
            System.out.println();
            System.out.println("Checking exceptions:");
            try {
                METRE.convert(5.0, SECOND);
                System.err.println("ERROR: [s] -> [m]");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                METRE_PER_SECOND.convert(5.0, JOULE);
                System.err.println("ERROR: [J] -> [m/s]");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                MILE_PER_HOUR.convert(5.0, POUND_PER_SECOND);
                System.err.println("ERROR: [pound/s] -> [mile/h]");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                Unit.get("\u00b0C").pow(2);
                System.err.println("ERROR: [\u00b0C].pow(2)");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                Unit.get("\u00b0F").multiply(Unit.get("\u00b0C"));
                System.err.println("ERROR: [\u00b0F].multiply([\u00b0C])");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                Unit.get("\u00b0C").multiply(Unit.get("\u00b0F"));
                System.err.println("ERROR: [\u00b0C].multiply([\u00b0F])");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                Unit.get("\u00b0F").divide(Unit.get("\u00b0C"));
                System.err.println("ERROR: [\u00b0F].divide([\u00b0C])");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            try {
                Unit.get("\u00b0C").divide(Unit.get("\u00b0F"));
                System.err.println("ERROR: [\u00b0C].divide([\u00b0F])");
                System.exit(1);
            }
            catch (UnitException e) {
                System.out.println(e.getMessage());
            }
            System.out.println("pool.size= " + Prefix.pool.size());
            System.gc();
            System.out.println("pool.size= " + Prefix.pool.size());
            System.out.flush();
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(new File(PATHNAME)));
        out.writeObject(units.units);
        out.close();
    }
}

