/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Iterator;
import org.geotools.resources.rsc.Resources;
import org.geotools.resources.units.Quantities;
import org.geotools.resources.units.Units;
import org.geotools.units.BaseUnit;
import org.geotools.units.DMSUnit;
import org.geotools.units.DerivedUnit;
import org.geotools.units.Prefix;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledUnit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitFormat;
import org.geotools.units.UnitTransform;
import org.geotools.util.WeakHashSet;

public abstract class Unit
implements Serializable {
    private static final long serialVersionUID = 8745958719541785628L;
    private static final WeakHashSet pool = Prefix.pool;
    public static final Unit DIMENSIONLESS = DerivedUnit.DIMENSIONLESS;
    public static final Unit RADIAN = Unit.get("rad");
    public static final Unit DEGREE = Unit.get("\u00b0");
    public static final Unit METRE = Unit.get("m");
    public static final Unit KILOMETRE = METRE.scale(1000.0);
    public static final Unit SECOND = Unit.get("s");
    public static final Unit MILLISECOND = Unit.get("ms");
    public static final Unit DAY = Unit.get("d");
    public static final Unit KILOGRAM = Unit.get("kg");
    public static final Unit ARC_SECOND = DEGREE.scale(2.777777777777778E-4);
    public static final Unit DMS = new DMSUnit(1).intern();
    public static final Unit SEXAGESIMAL_DEGREE = new DMSUnit(10000).intern();
    final String symbol;
    final PrefixSet prefix;
    static /* synthetic */ Class class$0;

    Unit(String symbol, PrefixSet prefix) throws NullPointerException {
        this.symbol = symbol.trim();
        this.prefix = prefix;
    }

    public static Unit get(String symbol) {
        Object unit = null;
        Unit[] units = null;
        int i = 0;
        while (i < 3) {
            switch (i) {
                case 2: {
                    units = Unit.getDefaultUnits();
                }
                case 1: {
                    unit = UnitFormat.DEFAULT.parse(symbol);
                    break;
                }
                case 0: {
                    unit = Unit.getCached(symbol);
                }
            }
            if (unit instanceof Unit) {
                return (Unit)unit;
            }
            ++i;
        }
        return null;
    }

    private static Unit[] getDefaultUnits() {
        InputStream in;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geotools.units.Unit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((in = clazz.getClassLoader().getResourceAsStream("org/geotools/units/database.serialized")) != null) {
            try {
                ObjectInputStream oin = new ObjectInputStream(in);
                Unit[] units = (Unit[])oin.readObject();
                oin.close();
                int i = 0;
                while (i < units.length) {
                    units[i] = units[i].intern();
                    ++i;
                }
                return units;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    static Unit getCached(String symbol) {
        Iterator it = pool.iterator();
        while (it.hasNext()) {
            Object object = it.next();
            if (!(object instanceof Unit)) continue;
            Unit unit = (Unit)object;
            if (!unit.symbol.equals(symbol)) continue;
            return unit;
        }
        return null;
    }

    public abstract Unit rename(String var1, PrefixSet var2);

    public String getLocalizedName() {
        return Units.localize(this.symbol);
    }

    public abstract String getQuantityName();

    public String getLocalizedQuantityName() {
        return Quantities.localize(this.getQuantityName());
    }

    public Unit pow(int power) throws UnitException {
        switch (power) {
            case 0: {
                return DerivedUnit.DIMENSIONLESS;
            }
            case 1: {
                return this;
            }
        }
        throw new UnitException(Resources.format(3, new Integer(power), this), this, null);
    }

    public Unit pow(double power) throws UnitException {
        int integer = (int)power;
        if ((double)integer == power) {
            return this.pow(integer);
        }
        throw new UnitException(Resources.format(3, new Double(power), this), this, null);
    }

    public Unit multiply(Unit that) throws UnitException {
        if (DerivedUnit.DIMENSIONLESS.equals(that)) {
            return this;
        }
        throw this.illegalUnitOperationException(that);
    }

    Unit inverseMultiply(BaseUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    Unit inverseMultiply(DerivedUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    Unit inverseMultiply(ScaledUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    public Unit divide(Unit that) throws UnitException {
        if (DerivedUnit.DIMENSIONLESS.equals(that)) {
            return this;
        }
        throw this.illegalUnitOperationException(that);
    }

    Unit inverseDivide(BaseUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    Unit inverseDivide(DerivedUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    Unit inverseDivide(ScaledUnit that) throws UnitException {
        throw that.illegalUnitOperationException(this);
    }

    public abstract Unit scale(double var1);

    public abstract Unit shift(double var1);

    public abstract boolean canConvert(Unit var1);

    boolean canConvert(BaseUnit that) {
        return this.canConvert((Unit)that);
    }

    boolean canConvert(DerivedUnit that) {
        return this.canConvert((Unit)that);
    }

    public abstract double convert(double var1, Unit var3) throws UnitException;

    double convert(double value, BaseUnit fromUnit) throws UnitException {
        return this.convert(value, (Unit)fromUnit);
    }

    double convert(double value, DerivedUnit fromUnit) throws UnitException {
        return this.convert(value, (Unit)fromUnit);
    }

    public abstract void convert(double[] var1, Unit var2) throws UnitException;

    void convert(double[] values, BaseUnit fromUnit) throws UnitException {
        this.convert(values, (Unit)fromUnit);
    }

    void convert(double[] values, DerivedUnit fromUnit) throws UnitException {
        this.convert(values, (Unit)fromUnit);
    }

    public abstract void convert(float[] var1, Unit var2) throws UnitException;

    void convert(float[] values, BaseUnit fromUnit) throws UnitException {
        this.convert(values, (Unit)fromUnit);
    }

    void convert(float[] values, DerivedUnit fromUnit) throws UnitException {
        this.convert(values, (Unit)fromUnit);
    }

    public abstract UnitTransform getTransform(Unit var1) throws UnitException;

    UnitTransform getTransform(BaseUnit fromUnit) throws UnitException {
        return this.getTransform((Unit)fromUnit);
    }

    UnitTransform getTransform(DerivedUnit fromUnit) throws UnitException {
        return this.getTransform((Unit)fromUnit);
    }

    abstract double inverseConvert(double var1, Unit var3) throws UnitException;

    double inverseConvert(double value, BaseUnit toUnit) throws UnitException {
        return this.inverseConvert(value, (Unit)toUnit);
    }

    double inverseConvert(double value, DerivedUnit toUnit) throws UnitException {
        return this.inverseConvert(value, (Unit)toUnit);
    }

    abstract void inverseConvert(double[] var1, Unit var2) throws UnitException;

    void inverseConvert(double[] values, BaseUnit toUnit) throws UnitException {
        this.inverseConvert(values, (Unit)toUnit);
    }

    void inverseConvert(double[] values, DerivedUnit toUnit) throws UnitException {
        this.inverseConvert(values, (Unit)toUnit);
    }

    abstract void inverseConvert(float[] var1, Unit var2) throws UnitException;

    void inverseConvert(float[] values, BaseUnit toUnit) throws UnitException {
        this.inverseConvert(values, (Unit)toUnit);
    }

    void inverseConvert(float[] values, DerivedUnit toUnit) throws UnitException {
        this.inverseConvert(values, (Unit)toUnit);
    }

    abstract UnitTransform getInverseTransform(Unit var1) throws UnitException;

    UnitTransform getInverseTransform(BaseUnit toUnit) throws UnitException {
        return this.getInverseTransform((Unit)toUnit);
    }

    UnitTransform getInverseTransform(DerivedUnit toUnit) throws UnitException {
        return this.getInverseTransform((Unit)toUnit);
    }

    final UnitException illegalUnitOperationException(Unit that) {
        return new UnitException(Resources.format(2, this, that), this, that);
    }

    final UnitException incompatibleUnitsException(Unit that) {
        return new UnitException(Resources.format(8, this, that), this, that);
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }

    final Unit intern() {
        return (Unit)pool.canonicalize(this);
    }

    final Unit internIgnoreSymbol() {
        WeakHashSet weakHashSet = pool;
        synchronized (weakHashSet) {
            Object canonical = pool.get(new Unamed());
            if (canonical instanceof Unit) {
                return (Unit)canonical;
            }
            pool.add(this);
            return this;
        }
    }

    public boolean equals(Object unit) {
        if (unit != null) {
            if (unit instanceof Unamed) {
                return unit.equals(this);
            }
            if (this.getClass().equals(unit.getClass())) {
                Unit cast = (Unit)unit;
                if (this.symbol.equals(cast.symbol) && this.equalsIgnoreSymbol(cast)) {
                    if (this.prefix == cast.prefix) {
                        return true;
                    }
                    if (this.prefix == null) {
                        return false;
                    }
                    return this.prefix.equals(cast.prefix);
                }
            }
        }
        return false;
    }

    abstract boolean equalsIgnoreSymbol(Unit var1);

    public abstract int hashCode();

    public String toString() {
        return this.symbol;
    }

    private final class Unamed {
        Unamed() {
        }

        public int hashCode() {
            return Unit.this.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Unit && Unit.this.equalsIgnoreSymbol((Unit)obj);
        }
    }
}

