/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.units.Prefix;
import org.geotools.util.WeakHashSet;

final class PrefixSet
implements Serializable {
    private static final long serialVersionUID = -8301096197856692402L;
    private static final WeakHashSet pool;
    private final Prefix[] prefix;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.geotools.units.PrefixSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        pool = Prefix.pool;
    }

    private PrefixSet(Prefix[] p) {
        int length;
        Object[] px = new Prefix[p.length];
        System.arraycopy(p, 0, px, 0, px.length);
        Arrays.sort(px);
        int i = length = px.length;
        while (--i >= 1) {
            if (((Prefix)px[i]).amount != ((Prefix)px[i - 1]).amount) continue;
            px[i] = null;
            --length;
        }
        i = 0;
        this.prefix = new Prefix[length];
        int j = 0;
        while (j < px.length) {
            if (px[j] != null) {
                this.prefix[i++] = px[j];
            }
            ++j;
        }
        if (!$assertionsDisabled && i != length) {
            throw new AssertionError();
        }
    }

    public static PrefixSet getPrefixSet(Prefix[] p) {
        return new PrefixSet(p).intern();
    }

    public Prefix getPrefix(String symbol) {
        int i = 0;
        while (i < this.prefix.length) {
            Prefix p = this.prefix[i];
            if (symbol.equals(p.symbol)) {
                return p;
            }
            ++i;
        }
        return null;
    }

    public Prefix getPrefix(double amount) {
        int index;
        if ((index = Arrays.binarySearch(this.prefix, new Prefix(amount += 1.0E-8 * Math.abs(amount)))) < 0) {
            if ((index ^= 0xFFFFFFFF) == 0) {
                return null;
            }
            if (index > this.prefix.length) {
                index = this.prefix.length;
            }
            --index;
        }
        return this.prefix[index];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.prefix.length) {
            Prefix p = this.prefix[i];
            String name = p.getLocalizedName();
            String symb = p.symbol;
            if (name.length() != 0 || symb.length() != 0) {
                if (buffer.length() != 0) {
                    buffer.append(',');
                }
                buffer.append(name);
                if (symb.length() != 0) {
                    buffer.append('(');
                    buffer.append(symb);
                    buffer.append(')');
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public boolean equals(Object other) {
        Prefix[] array;
        if (other == this) {
            return true;
        }
        if (other instanceof PrefixSet && this.prefix.length == (array = ((PrefixSet)other).prefix).length) {
            int i = 0;
            while (i < array.length) {
                if (!this.prefix[i].equals(array[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = this.prefix.length << 1;
        int i = 0;
        while (i < this.prefix.length) {
            code += this.prefix[i].hashCode();
            i += 5;
        }
        return code;
    }

    private final PrefixSet intern() {
        return (PrefixSet)pool.canonicalize(this);
    }

    final Object readResolve() throws ObjectStreamException {
        return this.intern();
    }
}

