/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.rsc.Resources;
import org.geotools.units.CompoundTransform;
import org.geotools.units.IdentityTransform;
import org.geotools.units.OffsetTransform;
import org.geotools.units.PrefixSet;
import org.geotools.units.ScaledTransform;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitFormat;
import org.geotools.units.UnitTransform;

final class OffsetUnit
extends Unit {
    private static final long serialVersionUID = 6259444767590765138L;
    public final double offset;
    public final Unit unit;

    private OffsetUnit(double offset, Unit unit, String symbol, PrefixSet prefix) {
        super(symbol, prefix);
        this.offset = offset;
        this.unit = unit;
        if (unit == null) {
            throw new NullPointerException(Resources.format(14));
        }
        if (Double.isNaN(offset) || Double.isInfinite(offset)) {
            throw new IllegalArgumentException(Resources.format(11, new Double(offset)));
        }
    }

    public static Unit getInstance(double offset, Unit unit) {
        return OffsetUnit.getInstance(offset, unit, null, null);
    }

    public static Unit getInstance(double offset, Unit unit, String symbol, PrefixSet prefix) {
        if (offset == 0.0) {
            if (unit == null) {
                throw new NullPointerException(Resources.format(14));
            }
            return unit;
        }
        if (symbol == null) {
            return new OffsetUnit(offset, unit, UnitFormat.DEFAULT.formatOffset(offset, unit, new StringBuffer()).toString(), null).internIgnoreSymbol();
        }
        return new OffsetUnit(offset, unit, symbol, prefix).intern();
    }

    public Unit rename(String symbol, PrefixSet prefix) {
        return OffsetUnit.getInstance(this.offset, this.unit, symbol, prefix);
    }

    public String getQuantityName() {
        return this.unit.getQuantityName();
    }

    public Unit scale(double amount) {
        return amount == 1.0 ? this : OffsetUnit.getInstance(this.offset / amount, this.unit.scale(amount));
    }

    public Unit shift(double offset) {
        return offset == 0.0 ? this : OffsetUnit.getInstance(this.offset + offset, this.unit);
    }

    public boolean canConvert(Unit that) {
        return this.unit.canConvert(that);
    }

    public double convert(double value, Unit fromUnit) throws UnitException {
        if (fromUnit == this) {
            return value;
        }
        return this.unit.convert(value, fromUnit) - this.offset;
    }

    public void convert(double[] values, Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            this.unit.convert(values, fromUnit);
            int i = 0;
            while (i < values.length) {
                int n = i++;
                values[n] = values[n] - this.offset;
            }
        }
    }

    public void convert(float[] values, Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            this.unit.convert(values, fromUnit);
            int i = 0;
            while (i < values.length) {
                values[i] = (float)((double)values[i] - this.offset);
                ++i;
            }
        }
    }

    public UnitTransform getTransform(Unit fromUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(fromUnit)) {
            UnitTransform tr = this.unit.getTransform(fromUnit);
            if (tr instanceof OffsetTransform) {
                return OffsetTransform.getInstance(fromUnit, this, ((OffsetTransform)tr).offset + this.offset);
            }
            return CompoundTransform.getInstance(tr, OffsetTransform.getInstance(this.unit, this, this.offset));
        }
        return IdentityTransform.getInstance(fromUnit, this);
    }

    protected double inverseConvert(double value, Unit toUnit) throws UnitException {
        if (toUnit == this) {
            return value;
        }
        return this.unit.inverseConvert(value + this.offset, toUnit);
    }

    protected void inverseConvert(double[] values, Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            if (this.unit.canConvert(toUnit)) {
                int i = 0;
                while (i < values.length) {
                    int n = i++;
                    values[n] = values[n] + this.offset;
                }
                this.unit.inverseConvert(values, toUnit);
            } else {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected void inverseConvert(float[] values, Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            if (this.unit.canConvert(toUnit)) {
                int i = 0;
                while (i < values.length) {
                    values[i] = (float)((double)values[i] + this.offset);
                    ++i;
                }
                this.unit.inverseConvert(values, toUnit);
            } else {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected UnitTransform getInverseTransform(Unit toUnit) throws UnitException {
        if (!this.equalsIgnoreSymbol(toUnit)) {
            UnitTransform tr = this.unit.getInverseTransform(toUnit);
            if (tr instanceof OffsetTransform) {
                return ScaledTransform.getInstance(this, toUnit, ((OffsetTransform)tr).offset - this.offset);
            }
            return CompoundTransform.getInstance(OffsetTransform.getInstance(this, this.unit, -this.offset), tr);
        }
        return IdentityTransform.getInstance(this, toUnit);
    }

    public boolean equalsIgnoreSymbol(Unit unit) {
        if (unit instanceof OffsetUnit) {
            OffsetUnit that = (OffsetUnit)unit;
            return Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(that.offset) && this.unit.equalsIgnoreSymbol(that.unit);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.offset);
        return (int)code ^ (int)(code >>> 32) ^ this.unit.hashCode();
    }
}

