/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.units;

import org.geotools.resources.rsc.Resources;
import org.geotools.units.BaseUnit;
import org.geotools.units.Factor;
import org.geotools.units.IdentityTransform;
import org.geotools.units.InverseTransform;
import org.geotools.units.PrefixSet;
import org.geotools.units.SimpleUnit;
import org.geotools.units.Unit;
import org.geotools.units.UnitException;
import org.geotools.units.UnitFormat;
import org.geotools.units.UnitTransform;

final class DerivedUnit
extends SimpleUnit {
    private static final long serialVersionUID = -4476414709268904273L;
    static final Unit DIMENSIONLESS = new DerivedUnit().intern();
    private final Factor[] factors;

    private DerivedUnit() {
        this("dimensionless", "", null, new Factor[0]);
    }

    private DerivedUnit(Factor[] factors) {
        super(null, UnitFormat.DEFAULT.format(factors, new StringBuffer()).toString(), null);
        this.factors = factors;
    }

    private DerivedUnit(String quantityName, String symbol, PrefixSet prefix, Factor[] factors) {
        super(quantityName, symbol, prefix);
        this.factors = factors;
    }

    public static SimpleUnit getInstance(Factor[] factors) {
        return DerivedUnit.getInstance(null, null, null, factors);
    }

    public static SimpleUnit getInstance(String quantityName, String symbol, PrefixSet prefix, Factor[] factors) {
        Factor fi;
        Factor[] oldFactors = factors;
        factors = new Factor[oldFactors.length];
        System.arraycopy(oldFactors, 0, factors, 0, factors.length);
        int i = 0;
        while (i < factors.length) {
            Factor fi2 = factors[i];
            if (fi2 != null) {
                BaseUnit ui = fi2.baseUnit;
                int j = i + 1;
                while (j < factors.length) {
                    Factor fj = factors[j];
                    if (fj != null && ui.equalsIgnoreSymbol(fj.baseUnit)) {
                        factors[i] = fi2 = Factor.getFactor(ui, fi2.power + fj.power);
                        factors[j] = null;
                    }
                    ++j;
                }
            }
            ++i;
        }
        int length = 0;
        int i2 = 0;
        while (i2 < factors.length) {
            fi = factors[i2];
            if (fi != null && fi.power != 0) {
                ++length;
            }
            ++i2;
        }
        if (factors.length != length) {
            oldFactors = factors;
            factors = new Factor[length];
            i2 = oldFactors.length;
            while (--i2 >= 0) {
                fi = oldFactors[i2];
                if (fi == null || fi.power == 0) continue;
                factors[--length] = fi;
            }
        }
        switch (factors.length) {
            case 0: {
                return (SimpleUnit)DIMENSIONLESS;
            }
            case 1: {
                if (factors[0].power != 1) break;
                return factors[0].baseUnit;
            }
        }
        if (symbol != null) {
            return (SimpleUnit)new DerivedUnit(quantityName, symbol, prefix, factors).intern();
        }
        return (SimpleUnit)new DerivedUnit(factors).internIgnoreSymbol();
    }

    public Unit rename(String symbol, PrefixSet prefix) {
        return DerivedUnit.getInstance(this.quantityName, symbol, prefix, this.factors);
    }

    public Unit pow(int power) {
        switch (power) {
            case 0: {
                return DIMENSIONLESS;
            }
            case 1: {
                return this;
            }
        }
        Factor[] newFactors = new Factor[this.factors.length];
        int i = 0;
        while (i < newFactors.length) {
            newFactors[i] = Factor.getFactor(this.factors[i].baseUnit, this.factors[i].power * power);
            ++i;
        }
        return DerivedUnit.getInstance(newFactors);
    }

    public Unit pow(double power) throws UnitException {
        int integer = (int)power;
        if ((double)integer == power) {
            return this.pow(integer);
        }
        Factor[] newFactors = new Factor[this.factors.length];
        int i = 0;
        while (i < newFactors.length) {
            float floatPower = (float)((double)this.factors[i].power * power);
            int integerPower = (int)floatPower;
            if ((float)integerPower != floatPower) {
                throw new UnitException(Resources.format(3, new Double(power), this), this, null);
            }
            newFactors[i] = Factor.getFactor(this.factors[i].baseUnit, integerPower);
            ++i;
        }
        return DerivedUnit.getInstance(newFactors);
    }

    public Unit multiply(Unit that) throws UnitException {
        return that.inverseMultiply(this);
    }

    Unit inverseMultiply(BaseUnit that) throws UnitException {
        return DerivedUnit.multiply(new Factor[]{Factor.getFactor(that, 1)}, this.factors, 1);
    }

    Unit inverseMultiply(DerivedUnit that) throws UnitException {
        return that.multiply(this.factors);
    }

    final SimpleUnit multiply(Factor[] f) {
        return DerivedUnit.multiply(this.factors, f, 1);
    }

    private static SimpleUnit multiply(Factor[] f1, Factor[] f2, int power2) {
        Factor[] factors = new Factor[f1.length + f2.length];
        System.arraycopy(f1, 0, factors, 0, f1.length);
        System.arraycopy(f2, 0, factors, f1.length, f2.length);
        switch (power2) {
            case 1: {
                break;
            }
            case -1: {
                int i = f1.length;
                while (i < factors.length) {
                    factors[i] = factors[i].inverse();
                    ++i;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(power2));
            }
        }
        return DerivedUnit.getInstance(factors);
    }

    public Unit divide(Unit that) throws UnitException {
        return that.inverseDivide(this);
    }

    Unit inverseDivide(BaseUnit that) throws UnitException {
        return DerivedUnit.multiply(new Factor[]{Factor.getFactor(that, 1)}, this.factors, -1);
    }

    Unit inverseDivide(DerivedUnit that) throws UnitException {
        return DerivedUnit.multiply(that.factors, this.factors, -1);
    }

    private int compareDimensionality(BaseUnit that) {
        if (this.factors.length == 1) {
            Factor factor = this.factors[0];
            if (factor.baseUnit.equalsIgnoreSymbol(that)) {
                switch (factor.power) {
                    case -1: {
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                }
            }
        }
        return 0;
    }

    private int compareDimensionality(DerivedUnit that) {
        int result = 0;
        int count = that.factors.length;
        Factor[] cmpFactors = new Factor[count];
        System.arraycopy(that.factors, 0, cmpFactors, 0, count);
        int i = 0;
        while (i < this.factors.length) {
            block7: {
                Factor factor = this.factors[i];
                int j = 0;
                while (j < cmpFactors.length) {
                    int cmp = factor.compareDimensionality(cmpFactors[j]);
                    if (cmp != 0) {
                        if (result != cmp) {
                            if (result != 0) {
                                return 0;
                            }
                            result = cmp;
                        }
                        --count;
                        break block7;
                    }
                    ++j;
                }
                return 0;
            }
            cmpFactors[j] = null;
            ++i;
        }
        if (count != 0) {
            return 0;
        }
        if (result == 0) {
            return 1;
        }
        return result;
    }

    public boolean canConvert(Unit that) {
        return that.canConvert(this);
    }

    boolean canConvert(BaseUnit that) {
        return this.compareDimensionality(that) != 0;
    }

    boolean canConvert(DerivedUnit that) {
        return this.compareDimensionality(that) != 0;
    }

    public double convert(double value, Unit fromUnit) throws UnitException {
        return fromUnit.inverseConvert(value, this);
    }

    double convert(double value, BaseUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                return 1.0 / value;
            }
            case 1: {
                return value;
            }
        }
        throw this.incompatibleUnitsException(fromUnit);
    }

    double convert(double value, DerivedUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                return 1.0 / value;
            }
            case 1: {
                return value;
            }
        }
        throw this.incompatibleUnitsException(fromUnit);
    }

    public void convert(double[] values, Unit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(double[] values, BaseUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0 / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw this.incompatibleUnitsException(fromUnit);
            }
        }
    }

    void convert(double[] values, DerivedUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0 / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw this.incompatibleUnitsException(fromUnit);
            }
        }
    }

    public void convert(float[] values, Unit fromUnit) throws UnitException {
        fromUnit.inverseConvert(values, this);
    }

    void convert(float[] values, BaseUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0f / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw this.incompatibleUnitsException(fromUnit);
            }
        }
    }

    void convert(float[] values, DerivedUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0f / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw this.incompatibleUnitsException(fromUnit);
            }
        }
    }

    public UnitTransform getTransform(Unit fromUnit) throws UnitException {
        return fromUnit.getInverseTransform(this);
    }

    UnitTransform getTransform(BaseUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                return InverseTransform.getInstance(fromUnit, this);
            }
            case 1: {
                return IdentityTransform.getInstance(fromUnit, this);
            }
        }
        throw this.incompatibleUnitsException(fromUnit);
    }

    UnitTransform getTransform(DerivedUnit fromUnit) throws UnitException {
        switch (this.compareDimensionality(fromUnit)) {
            case -1: {
                return InverseTransform.getInstance(fromUnit, this);
            }
            case 1: {
                return IdentityTransform.getInstance(fromUnit, this);
            }
        }
        throw this.incompatibleUnitsException(fromUnit);
    }

    protected double inverseConvert(double value, Unit toUnit) throws UnitException {
        return toUnit.convert(value, this);
    }

    double inverseConvert(double value, BaseUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                return 1.0 / value;
            }
            case 1: {
                return value;
            }
        }
        throw toUnit.incompatibleUnitsException(this);
    }

    double inverseConvert(double value, DerivedUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                return 1.0 / value;
            }
            case 1: {
                return value;
            }
        }
        throw toUnit.incompatibleUnitsException(this);
    }

    protected void inverseConvert(double[] values, Unit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(double[] values, BaseUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0 / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    void inverseConvert(double[] values, DerivedUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0 / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected void inverseConvert(float[] values, Unit toUnit) throws UnitException {
        toUnit.convert(values, this);
    }

    void inverseConvert(float[] values, BaseUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0f / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    void inverseConvert(float[] values, DerivedUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                int i = 0;
                while (i < values.length) {
                    values[i] = 1.0f / values[i];
                    ++i;
                }
            }
            case 1: {
                break;
            }
            default: {
                throw toUnit.incompatibleUnitsException(this);
            }
        }
    }

    protected UnitTransform getInverseTransform(Unit toUnit) throws UnitException {
        return toUnit.getTransform(this);
    }

    UnitTransform getInverseTransform(BaseUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                return InverseTransform.getInstance(this, toUnit);
            }
            case 1: {
                return IdentityTransform.getInstance(this, toUnit);
            }
        }
        throw toUnit.incompatibleUnitsException(this);
    }

    UnitTransform getInverseTransform(DerivedUnit toUnit) throws UnitException {
        switch (this.compareDimensionality(toUnit)) {
            case -1: {
                return InverseTransform.getInstance(this, toUnit);
            }
            case 1: {
                return IdentityTransform.getInstance(this, toUnit);
            }
        }
        throw toUnit.incompatibleUnitsException(this);
    }

    public boolean equalsIgnoreSymbol(Unit unit) {
        return unit instanceof DerivedUnit && this.compareDimensionality((DerivedUnit)unit) == 1;
    }

    public int hashCode() {
        int code = 92718538;
        int i = 0;
        while (i < this.factors.length) {
            code += this.factors[i].hashCode();
            ++i;
        }
        return code;
    }
}

